/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging.api.json.adapter;

import com.aregcraft.reforging.api.json.JsonReader;
import com.aregcraft.reforging.api.json.annotation.JsonAdapterFor;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.bukkit.Location;
import org.bukkit.World;

@JsonAdapterFor(value=Location.class)
public class LocationAdapter
implements JsonDeserializer<Location>,
JsonSerializer<Location> {
    public Location deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonReader reader = new JsonReader(context, json);
        return new Location(reader.get("world", World.class), reader.getDouble("x"), reader.getDouble("y"), reader.getDouble("z"), reader.getFloatOrElse("yaw", 0.0f), reader.getFloatOrElse("pitch", 0.0f));
    }

    public JsonElement serialize(Location src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject obj = new JsonObject();
        obj.add("world", context.serialize((Object)src.getWorld()));
        obj.addProperty("x", (Number)src.getX());
        obj.addProperty("y", (Number)src.getY());
        obj.addProperty("z", (Number)src.getZ());
        obj.addProperty("yaw", (Number)Float.valueOf(src.getYaw()));
        obj.addProperty("pitch", (Number)Float.valueOf(src.getPitch()));
        return obj;
    }
}

