/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging.api.json.adapter;

import com.aregcraft.reforging.api.item.ItemWrapper;
import com.aregcraft.reforging.api.json.JsonReader;
import com.aregcraft.reforging.api.json.annotation.JsonAdapterFor;
import com.aregcraft.reforging.api.util.CollectionMaps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.persistence.PersistentDataType;

@JsonAdapterFor(value=ItemWrapper.class)
public class ItemWrapperAdapter
implements JsonDeserializer<ItemWrapper>,
JsonSerializer<ItemWrapper> {
    private static final TypeToken<Map<Enchantment, Integer>> ENCHANTS_TYPE = new TypeToken<Map<Enchantment, Integer>>(){};
    private static final TypeToken<Map<Attribute, Collection<AttributeModifier>>> ATTRIBUTE_MODIFIERS_TYPE = new TypeToken<Map<Attribute, Collection<AttributeModifier>>>(){};
    private static final TypeToken<Map<String, PersistentDataEntry>> PERSISTENT_DATA_TYPE = new TypeToken<Map<String, PersistentDataEntry>>(){};

    public ItemWrapper deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        JsonReader reader = new JsonReader(context, json);
        ItemWrapper item = ItemWrapper.withMaterial(reader.get("material", Material.class));
        reader.acceptInt("amount", item::setAmount);
        reader.acceptInt("damage", item::setDamage);
        reader.acceptString("name", item::setName);
        reader.accept("lore", String[].class, item::setLore);
        reader.accept("enchants", ENCHANTS_TYPE, it -> it.forEach(item::addEnchant));
        reader.accept("flags", ItemFlag[].class, item::addFlags);
        reader.acceptBoolean("unbreakable", item::setUnbreakable);
        reader.accept("attributeModifiers", ATTRIBUTE_MODIFIERS_TYPE, it -> CollectionMaps.forEach(it, item::addAttributeModifier));
        reader.accept("persistentData", PERSISTENT_DATA_TYPE, it -> it.forEach((key, entry) -> entry.set(item, Objects.requireNonNull(NamespacedKey.fromString((String)key)))));
        return item;
    }

    public JsonElement serialize(ItemWrapper src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject obj = new JsonObject();
        obj.add("material", context.serialize((Object)src.getMaterial()));
        obj.addProperty("amount", (Number)src.getAmount());
        obj.addProperty("damage", (Number)src.getDamage());
        if (src.hasName()) {
            obj.addProperty("name", src.getUnformattedName());
        }
        obj.add("lore", context.serialize(src.getUnformattedLore()));
        obj.add("enchants", context.serialize(src.getEnchants()));
        obj.add("flags", context.serialize(src.getFlags()));
        obj.addProperty("unbreakable", Boolean.valueOf(src.isUnbreakable()));
        obj.add("attributeModifiers", context.serialize((Object)src.getAttributeModifiers().asMap()));
        JsonObject persistentData = new JsonObject();
        obj.add("persistentData", (JsonElement)persistentData);
        src.getMeta().getPersistentDataContainer().getKeys().forEach(it -> persistentData.add(it.toString(), context.serialize((Object)new PersistentDataEntry(src, (NamespacedKey)it))));
        return obj;
    }

    private static class PersistentDataEntry {
        private final PrimitivePersistentDataType type;
        private final Object value;

        private PersistentDataEntry(ItemWrapper item, NamespacedKey key) {
            this.type = PrimitivePersistentDataType.get(item, key);
            this.value = item.getMeta().getPersistentDataContainer().get(key, this.type.persistentDataType);
        }

        private void set(ItemWrapper item, NamespacedKey key) {
            item.editMeta(it -> it.getPersistentDataContainer().set(key, this.type.persistentDataType, this.value));
        }
    }

    private static enum PrimitivePersistentDataType {
        BYTE(PersistentDataType.BYTE),
        SHORT(PersistentDataType.SHORT),
        INTEGER(PersistentDataType.INTEGER),
        LONG(PersistentDataType.LONG),
        FLOAT(PersistentDataType.FLOAT),
        DOUBLE(PersistentDataType.DOUBLE),
        STRING(PersistentDataType.STRING),
        BYTE_ARRAY(PersistentDataType.BYTE_ARRAY),
        INTEGER_ARRAY(PersistentDataType.INTEGER_ARRAY),
        LONG_ARRAY(PersistentDataType.LONG_ARRAY),
        TAG_CONTAINER_ARRAY(PersistentDataType.TAG_CONTAINER_ARRAY),
        TAG_CONTAINER(PersistentDataType.TAG_CONTAINER);

        private final PersistentDataType<?, Object> persistentDataType;

        private PrimitivePersistentDataType(PersistentDataType<?, ?> persistentDataType) {
            this.persistentDataType = persistentDataType;
        }

        private static PrimitivePersistentDataType get(ItemWrapper item, NamespacedKey key) {
            return Arrays.stream(PrimitivePersistentDataType.values()).filter(it -> item.getMeta().getPersistentDataContainer().has(key, it.persistentDataType)).findAny().orElseThrow();
        }
    }
}

