/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging.api.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;

public class JsonReader {
    private final JsonDeserializationContext context;
    private final JsonObject obj;

    public JsonReader(JsonDeserializationContext context, JsonElement json) {
        this.context = context;
        this.obj = json.getAsJsonObject();
    }

    public String getString(String name) {
        return this.obj.get(name).getAsString();
    }

    public byte getByte(String name) {
        return this.obj.get(name).getAsByte();
    }

    public short getShort(String name) {
        return this.obj.get(name).getAsShort();
    }

    public int getInt(String name) {
        return this.obj.get(name).getAsInt();
    }

    public long getLong(String name) {
        return this.obj.get(name).getAsLong();
    }

    public float getFloat(String name) {
        return this.obj.get(name).getAsFloat();
    }

    public double getDouble(String name) {
        return this.obj.get(name).getAsDouble();
    }

    public boolean getBoolean(String name) {
        return this.obj.get(name).getAsBoolean();
    }

    public JsonObject getObject(String name) {
        return this.obj.getAsJsonObject(name);
    }

    public JsonArray getArray(String name) {
        return this.obj.getAsJsonArray(name);
    }

    public JsonReader getReader(String name) {
        return new JsonReader(this.context, (JsonElement)this.getObject(name));
    }

    public <T> T get(String name, Class<T> type) {
        return this.get(name, TypeToken.get(type));
    }

    public <T> T get(String name, TypeToken<T> type) {
        return (T)this.context.deserialize(this.obj.get(name), type.getType());
    }

    public String getStringOrElse(String name, String other) {
        return this.obj.has(name) ? this.getString(name) : other;
    }

    public byte getByteOrElse(String name, byte other) {
        return this.obj.has(name) ? this.getByte(name) : other;
    }

    public short getShortOrElse(String name, short other) {
        return this.obj.has(name) ? this.getShort(name) : other;
    }

    public int getIntOrElse(String name, int other) {
        return this.obj.has(name) ? this.getInt(name) : other;
    }

    public long getLongOrElse(String name, long other) {
        return this.obj.has(name) ? this.getLong(name) : other;
    }

    public float getFloatOrElse(String name, float other) {
        return this.obj.has(name) ? this.getFloat(name) : other;
    }

    public double getDoubleOrElse(String name, double other) {
        return this.obj.has(name) ? this.getDouble(name) : other;
    }

    public boolean getBooleanOrElse(String name, boolean other) {
        return this.obj.has(name) ? this.getBoolean(name) : other;
    }

    public <T> T getOrElse(String name, Class<T> type, T other) {
        return this.getOrElse(name, TypeToken.get(type), other);
    }

    public <T> T getOrElse(String name, TypeToken<T> type, T other) {
        return this.obj.has(name) ? this.get(name, type) : other;
    }

    public void acceptString(String name, Consumer<String> action) {
        if (this.obj.has(name)) {
            action.accept(this.getString(name));
        }
    }

    public void acceptByte(String name, Consumer<Byte> action) {
        if (this.obj.has(name)) {
            action.accept(this.getByte(name));
        }
    }

    public void acceptShort(String name, Consumer<Short> action) {
        if (this.obj.has(name)) {
            action.accept(this.getShort(name));
        }
    }

    public void acceptInt(String name, IntConsumer action) {
        if (this.obj.has(name)) {
            action.accept(this.getInt(name));
        }
    }

    public void acceptLong(String name, LongConsumer action) {
        if (this.obj.has(name)) {
            action.accept(this.getLong(name));
        }
    }

    public void acceptFloat(String name, Consumer<Float> action) {
        if (this.obj.has(name)) {
            action.accept(Float.valueOf(this.getFloat(name)));
        }
    }

    public void acceptDouble(String name, DoubleConsumer action) {
        if (this.obj.has(name)) {
            action.accept(this.getDouble(name));
        }
    }

    public void acceptBoolean(String name, Consumer<Boolean> action) {
        if (this.obj.has(name)) {
            action.accept(this.getBoolean(name));
        }
    }

    public <T> void accept(String name, Class<T> type, Consumer<T> action) {
        this.accept(name, TypeToken.get(type), action);
    }

    public <T> void accept(String name, TypeToken<T> type, Consumer<T> action) {
        if (this.obj.has(name)) {
            action.accept(this.get(name, type));
        }
    }

    public <T> T deserialize(JsonElement json, Class<T> type) {
        return (T)this.context.deserialize(json, type);
    }
}

