/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging.api.json;

import com.aregcraft.reforging.api.DeltaPlugin;
import com.aregcraft.reforging.api.json.annotation.JsonConfiguration;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class JsonConfigurationLoader {
    private final DeltaPlugin plugin;
    private final Map<TypeToken<?>, String> names;
    private final LoadingCache<PluginCacheKey, Object> cache;

    public JsonConfigurationLoader(DeltaPlugin plugin) {
        this(plugin, new HashMap());
    }

    private JsonConfigurationLoader(DeltaPlugin plugin, Map<TypeToken<?>, String> names) {
        this.plugin = plugin;
        this.names = names;
        plugin.getReflections().getTypesAnnotatedWith(JsonConfiguration.class).forEach(this::addConfiguration);
        this.cache = CacheBuilder.newBuilder().build((CacheLoader)new PluginCacheLoader());
    }

    private void addConfiguration(Class<?> type) {
        this.names.put(TypeToken.get(type), type.getAnnotation(JsonConfiguration.class).value());
    }

    public static Builder builder() {
        return new Builder();
    }

    public void invalidate(String name, Class<?> type) {
        this.invalidate(name, TypeToken.get(type));
    }

    public void invalidate(Class<?> type) {
        this.invalidate(TypeToken.get(type));
    }

    public void invalidate(String name, TypeToken<?> type) {
        this.cache.invalidate((Object)new PluginCacheKey(name, type));
    }

    public void invalidate(TypeToken<?> type) {
        this.invalidate(this.names.get(type), type);
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    public <T> T get(String name, Class<T> type) {
        return this.get(name, TypeToken.get(type));
    }

    public <T> T get(Class<T> type) {
        return this.get(TypeToken.get(type));
    }

    public <T> T get(String name, TypeToken<T> type) {
        return (T)this.cache.getUnchecked((Object)new PluginCacheKey(name, type));
    }

    public <T> T get(TypeToken<T> type) {
        return this.get(this.names.get(type), type);
    }

    public void set(String name, Object value) {
        PluginCacheKey key = new PluginCacheKey(name, TypeToken.get(value.getClass()));
        this.cache.put((Object)key, value);
        try (BufferedWriter writer = Files.newBufferedWriter(key.getPath(), new OpenOption[0]);){
            this.plugin.getGson().toJson(value, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void set(Object value) {
        this.set(this.names.get(TypeToken.get(value.getClass())), value);
    }

    private class PluginCacheLoader
    extends CacheLoader<PluginCacheKey, Object> {
        private PluginCacheLoader() {
        }

        public Object load(PluginCacheKey key) throws IOException {
            Path path = key.getPath();
            if (Files.notExists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.copy(key.getResource(), path, new CopyOption[0]);
            }
            try (BufferedReader reader = Files.newBufferedReader(path);){
                Object object = JsonConfigurationLoader.this.plugin.getGson().fromJson((Reader)reader, key.type.getType());
                return object;
            }
        }
    }

    public static class Builder {
        private final Map<TypeToken<?>, String> names = new HashMap();
        private DeltaPlugin plugin;

        private Builder() {
        }

        public Builder name(Class<?> type, String name) {
            return this.name(TypeToken.get(type), name);
        }

        public Builder name(TypeToken<?> type, String name) {
            this.names.put(type, name);
            return this;
        }

        public Builder plugin(DeltaPlugin plugin) {
            this.plugin = plugin;
            return this;
        }

        public JsonConfigurationLoader build() {
            return new JsonConfigurationLoader(this.plugin, this.names);
        }
    }

    private class PluginCacheKey {
        private final String name;
        private final TypeToken<?> type;

        private PluginCacheKey(String name, TypeToken<?> type) {
            this.name = name + ".json";
            this.type = type;
        }

        public Path getPath() {
            return JsonConfigurationLoader.this.plugin.getDataFolder().toPath().resolve(this.name);
        }

        public InputStream getResource() {
            return JsonConfigurationLoader.this.plugin.getResource(this.name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PluginCacheKey that = (PluginCacheKey)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type);
        }
    }
}

