/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging.api.json;

import com.aregcraft.reforging.api.DeltaPlugin;
import com.aregcraft.reforging.api.json.annotation.JsonAdapterFor;
import com.aregcraft.reforging.api.json.annotation.JsonHierarchyAdapterFor;
import com.aregcraft.reforging.api.util.Classes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;

public class GsonFactory {
    private final DeltaPlugin plugin;
    private final GsonBuilder builder;

    public GsonFactory(DeltaPlugin plugin) {
        this.plugin = plugin;
        this.builder = new GsonBuilder().enableComplexMapKeySerialization().setPrettyPrinting();
        this.registerTypeAdapterFactories();
        this.registerTypeHierarchyAdapters();
        this.registerTypeAdapters();
    }

    public Gson create() {
        return this.builder.create();
    }

    private void registerTypeAdapterFactories() {
        this.plugin.getReflections().getSubTypesOf(TypeAdapterFactory.class).forEach(this::registerTypeAdapterFactory);
    }

    private void registerTypeAdapterFactory(Class<? extends TypeAdapterFactory> type) {
        this.builder.registerTypeAdapterFactory(Classes.newInstanceWithPlugin(type, this.plugin));
    }

    private void registerTypeHierarchyAdapters() {
        this.plugin.getReflections().getTypesAnnotatedWith(JsonHierarchyAdapterFor.class).forEach(this::registerTypeHierarchyAdapter);
    }

    private void registerTypeHierarchyAdapter(Class<?> type) {
        this.builder.registerTypeHierarchyAdapter(type.getAnnotation(JsonHierarchyAdapterFor.class).value(), Classes.newInstanceWithPlugin(type, this.plugin));
    }

    private void registerTypeAdapters() {
        this.plugin.getReflections().getTypesAnnotatedWith(JsonAdapterFor.class).forEach(this::registerTypeAdapter);
    }

    private void registerTypeAdapter(Class<?> type) {
        this.builder.registerTypeAdapter(type.getAnnotation(JsonAdapterFor.class).value(), Classes.newInstanceWithPlugin(type, this.plugin));
    }
}

