/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging.api.item;

import com.aregcraft.reforging.api.AttributeModifierBuilder;
import com.aregcraft.reforging.api.DeltaPlugin;
import com.aregcraft.reforging.api.FormattingContext;
import com.aregcraft.reforging.api.PersistentDataWrapper;
import com.aregcraft.reforging.api.item.ItemDisplay;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;

public class ItemWrapper {
    private final ItemStack stack;
    private ItemMeta meta;
    private FormattingContext nameFormattingContext = FormattingContext.DEFAULT;
    private FormattingContext loreFormattingContext = FormattingContext.DEFAULT;

    private ItemWrapper(ItemStack stack) {
        this.stack = stack;
        this.meta = stack.getItemMeta();
    }

    public static ItemWrapper wrap(ItemWrapper item) {
        return ItemWrapper.wrap(item.stack.clone()).createBuilder().nameFormattingContext(item.nameFormattingContext).loreFormattingContext(item.loreFormattingContext).build();
    }

    public static ItemWrapper wrap(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        return new ItemWrapper(stack);
    }

    public static ItemWrapper withMaterial(Material material) {
        return ItemWrapper.wrap(new ItemStack(material));
    }

    public static Builder builder() {
        return ItemWrapper.withMaterial(Material.AIR).createBuilder();
    }

    public Builder createBuilder() {
        return new Builder();
    }

    public void setFormattingContext(FormattingContext formattingContext) {
        this.setNameFormattingContext(formattingContext);
        this.setLoreFormattingContext(formattingContext);
    }

    public void setNameFormattingContext(FormattingContext nameFormattingContext) {
        this.nameFormattingContext = nameFormattingContext;
        this.setName(this.getName());
    }

    public void setLoreFormattingContext(FormattingContext loreFormattingContext) {
        this.loreFormattingContext = loreFormattingContext;
        this.setLore(this.getLore());
    }

    public Material getMaterial() {
        return this.stack.getType();
    }

    public void setMaterial(Material material) {
        this.stack.setType(material);
        this.meta = this.stack.getItemMeta();
    }

    public int getAmount() {
        return this.stack.getAmount();
    }

    public void setAmount(int amount) {
        this.stack.setAmount(amount);
    }

    public void incrementAmount(int amount) {
        this.setAmount(this.getAmount() + amount);
    }

    public void decrementAmount(int amount) {
        this.incrementAmount(-amount);
    }

    public void incrementAmount() {
        this.incrementAmount(1);
    }

    public void decrementAmount() {
        this.decrementAmount(1);
    }

    public int getDamage() {
        return ((Damageable)this.meta).getDamage();
    }

    public void setDamage(int damage) {
        this.editMeta(it -> ((Damageable)it).setDamage(damage));
    }

    public ItemDisplay getDisplay() {
        return new ItemDisplay(this.getName(), this.getLore());
    }

    public void setDisplay(ItemDisplay display) {
        this.setName(display.name());
        this.setLore(display.lore().stream().filter(this.loreFormattingContext::isDisplayable).toList());
    }

    public boolean hasName() {
        return this.meta.hasDisplayName();
    }

    public String getNameOrElse(String other) {
        return this.hasName() ? this.getName() : other;
    }

    public String getName() {
        return this.meta.getDisplayName();
    }

    public String getUnformattedName() {
        return this.nameFormattingContext.unformat(this.getName());
    }

    public void setName(String name) {
        this.editMeta(it -> it.setDisplayName(ChatColor.RESET + this.nameFormattingContext.format(name)));
    }

    public List<String> getLore() {
        return Optional.ofNullable(this.meta.getLore()).orElseGet(Collections::emptyList);
    }

    public List<String> getUnformattedLore() {
        return this.getLore().stream().map(this.loreFormattingContext::unformat).toList();
    }

    public void setLore(List<String> lore) {
        this.editMeta(it -> it.setLore(this.formatLore(lore)));
    }

    public void setLore(String ... lore) {
        this.setLore(List.of(lore));
    }

    public void appendLore(List<String> lore) {
        ArrayList<String> newLore = new ArrayList<String>(this.getLore());
        newLore.addAll(lore);
        this.setLore(newLore);
    }

    public void appendLore(String ... lore) {
        this.appendLore(List.of(lore));
    }

    public void removeLore(List<String> lore) {
        ArrayList<String> newLore = new ArrayList<String>(this.getLore());
        newLore.removeAll(this.formatLore(lore));
        this.setLore(newLore);
    }

    public void removeLore(String ... lore) {
        this.removeLore(List.of(lore));
    }

    private List<String> formatLore(List<String> lore) {
        return lore.stream().map(this.loreFormattingContext::format).toList();
    }

    public boolean hasEnchants() {
        return this.meta.hasEnchants();
    }

    public boolean hasEnchant(Enchantment enchant) {
        return this.meta.hasEnchant(enchant);
    }

    public int getEnchantLevel(Enchantment enchant) {
        return this.meta.getEnchantLevel(enchant);
    }

    public Map<Enchantment, Integer> getEnchants() {
        return this.meta.getEnchants();
    }

    public void addEnchant(Enchantment enchant, int level) {
        this.editMeta(it -> it.addEnchant(enchant, level, true));
    }

    public void removeEnchant(Enchantment enchant) {
        this.editMeta(it -> it.removeEnchant(enchant));
    }

    public boolean hasConflictingEnchant(Enchantment enchant) {
        return this.meta.hasConflictingEnchant(enchant);
    }

    public Set<ItemFlag> getFlags() {
        return this.meta.getItemFlags();
    }

    public boolean hasFlag(ItemFlag flag) {
        return this.meta.hasItemFlag(flag);
    }

    public void addFlags(ItemFlag ... flags) {
        this.editMeta(it -> it.addItemFlags(flags));
    }

    public void removeFlags(ItemFlag ... flags) {
        this.editMeta(it -> it.removeItemFlags(flags));
    }

    public boolean isUnbreakable() {
        return this.meta.isUnbreakable();
    }

    public void setUnbreakable(boolean unbreakable) {
        this.editMeta(it -> it.setUnbreakable(unbreakable));
    }

    public void makeUnbreakable() {
        this.setUnbreakable(true);
    }

    public void makeBreakable() {
        this.setUnbreakable(false);
    }

    public AttributeModifierBuilder createAttributeModifierBuilder() {
        return AttributeModifierBuilder.forItem(this);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers() {
        return Optional.ofNullable(this.meta.getAttributeModifiers()).orElseGet(ImmutableMultimap::of);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot) {
        return this.meta.getAttributeModifiers(slot);
    }

    public Collection<AttributeModifier> getAttributeModifiers(Attribute attribute) {
        return Optional.ofNullable(this.meta.getAttributeModifiers(attribute)).orElseGet(Collections::emptyList);
    }

    public List<AttributeModifier> getAttributeModifiers(Attribute attribute, AttributeModifier.Operation operation) {
        return this.getAttributeModifiers(attribute).stream().filter(it -> it.getOperation().equals((Object)operation)).toList();
    }

    public double getAttributeValue(Attribute attribute) {
        return this.getAttributeModifierAdditionValue(attribute) * this.getAttributeModifierMultiplicationValue(attribute);
    }

    private double getAttributeModifierAdditionValue(Attribute attribute) {
        return this.getAttributeModifiers(attribute, AttributeModifier.Operation.ADD_NUMBER).stream().mapToDouble(AttributeModifier::getAmount).sum();
    }

    private double getAttributeModifierMultiplicationValue(Attribute attribute) {
        return this.getAttributeModifiers(attribute, AttributeModifier.Operation.MULTIPLY_SCALAR_1).stream().mapToDouble(AttributeModifier::getAmount).map(it -> it + 1.0).reduce(1.0, (a, b) -> a * b);
    }

    public AttributeModifier getAttributeModifier(Attribute attribute, String name) {
        return this.getAttributeModifiers(attribute).stream().filter(it -> it.getName().equals(name)).findAny().orElse(null);
    }

    public void addAttributeModifier(Attribute attribute, AttributeModifier modifier) {
        this.editMeta(it -> it.addAttributeModifier(attribute, modifier));
    }

    public void setAttributeModifiers(Multimap<Attribute, AttributeModifier> attributeModifiers) {
        this.editMeta(it -> it.setAttributeModifiers(attributeModifiers));
    }

    public void removeAttributeModifiers(Attribute attribute) {
        this.editMeta(it -> it.removeAttributeModifier(attribute));
    }

    public void removeAttributeModifiers(EquipmentSlot slot) {
        this.editMeta(it -> it.removeAttributeModifier(slot));
    }

    public void removeAttributeModifiers(String name) {
        this.getAttributeModifiers().forEach((attribute, modifier) -> {
            if (modifier.getName().equals(name)) {
                this.removeAttributeModifier((Attribute)attribute, (AttributeModifier)modifier);
            }
        });
    }

    public void removeAttributeModifier(Attribute attribute, AttributeModifier modifier) {
        this.editMeta(it -> it.removeAttributeModifier(attribute, modifier));
    }

    public PersistentDataWrapper getPersistentData(DeltaPlugin plugin) {
        return PersistentDataWrapper.wrap(plugin, (PersistentDataHolder)this.meta, it -> this.stack.setItemMeta(this.meta));
    }

    public void dropNaturally(Location location) {
        Objects.requireNonNull(location.getWorld()).dropItemNaturally(location, this.stack);
    }

    public ItemStack unwrap() {
        return this.stack;
    }

    public <T extends ItemMeta> void editMeta(Consumer<T> action) {
        action.accept(this.meta);
        this.stack.setItemMeta(this.meta);
    }

    public ItemMeta getMeta() {
        return this.meta;
    }

    public void setMeta(ItemMeta meta) {
        this.meta = meta;
        this.stack.setItemMeta(meta);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Objects.equals(this.stack, ((ItemWrapper)o).stack);
    }

    public int hashCode() {
        return Objects.hash(this.stack);
    }

    public class Builder {
        private Builder() {
        }

        public Builder formattingContext(FormattingContext formattingContext) {
            ItemWrapper.this.setFormattingContext(formattingContext);
            return this;
        }

        public Builder nameFormattingContext(FormattingContext nameFormattingContext) {
            ItemWrapper.this.setNameFormattingContext(nameFormattingContext);
            return this;
        }

        public Builder loreFormattingContext(FormattingContext loreFormattingContext) {
            ItemWrapper.this.setLoreFormattingContext(loreFormattingContext);
            return this;
        }

        public Builder material(Material material) {
            ItemWrapper.this.setMaterial(material);
            return this;
        }

        public Builder amount(int amount) {
            ItemWrapper.this.setAmount(amount);
            return this;
        }

        public Builder incrementAmount(int amount) {
            ItemWrapper.this.incrementAmount(amount);
            return this;
        }

        public Builder decrementAmount(int amount) {
            ItemWrapper.this.decrementAmount(amount);
            return this;
        }

        public Builder incrementAmount() {
            ItemWrapper.this.incrementAmount();
            return this;
        }

        public Builder decrementAmount() {
            ItemWrapper.this.decrementAmount();
            return this;
        }

        public Builder damage(int damage) {
            ItemWrapper.this.setDamage(damage);
            return this;
        }

        public Builder display(ItemDisplay display) {
            ItemWrapper.this.setDisplay(display);
            return this;
        }

        public Builder name(String name) {
            ItemWrapper.this.setName(name);
            return this;
        }

        public Builder lore(List<String> lore) {
            ItemWrapper.this.setLore(lore);
            return this;
        }

        public Builder lore(String ... lore) {
            ItemWrapper.this.setLore(lore);
            return this;
        }

        public Builder appendLore(List<String> lore) {
            ItemWrapper.this.appendLore(lore);
            return this;
        }

        public Builder appendLore(String ... lore) {
            ItemWrapper.this.appendLore(lore);
            return this;
        }

        public Builder removeLore(List<String> lore) {
            ItemWrapper.this.removeLore(lore);
            return this;
        }

        public Builder removeLore(String ... lore) {
            ItemWrapper.this.removeLore(lore);
            return this;
        }

        public Builder addEnchant(Enchantment enchant, int level) {
            ItemWrapper.this.addEnchant(enchant, level);
            return this;
        }

        public Builder removeEnchant(Enchantment enchant) {
            ItemWrapper.this.removeEnchant(enchant);
            return this;
        }

        public Builder addFlags(ItemFlag ... flags) {
            ItemWrapper.this.addFlags(flags);
            return this;
        }

        public Builder removeFlags(ItemFlag ... flags) {
            ItemWrapper.this.removeFlags(flags);
            return this;
        }

        public Builder makeUnbreakable() {
            ItemWrapper.this.makeUnbreakable();
            return this;
        }

        public Builder makeBreakable() {
            ItemWrapper.this.makeBreakable();
            return this;
        }

        public AttributeModifierBuilder attributeModifierBuilder() {
            return AttributeModifierBuilder.forItem(ItemWrapper.this);
        }

        public Builder addAttributeModifier(Attribute attribute, AttributeModifier modifier) {
            ItemWrapper.this.addAttributeModifier(attribute, modifier);
            return this;
        }

        public Builder attributeModifiers(Multimap<Attribute, AttributeModifier> attributeModifiers) {
            ItemWrapper.this.setAttributeModifiers(attributeModifiers);
            return this;
        }

        public Builder removeAttributeModifiers(Attribute attribute) {
            ItemWrapper.this.removeAttributeModifiers(attribute);
            return this;
        }

        public Builder removeAttributeModifiers(EquipmentSlot slot) {
            ItemWrapper.this.removeAttributeModifiers(slot);
            return this;
        }

        public Builder removeAttributeModifiers(String name) {
            ItemWrapper.this.removeAttributeModifiers(name);
            return this;
        }

        public Builder removeAttributeModifier(Attribute attribute, AttributeModifier modifier) {
            ItemWrapper.this.removeAttributeModifier(attribute, modifier);
            return this;
        }

        public Builder persistentData(DeltaPlugin plugin, String key, Object value) {
            ItemWrapper.this.getPersistentData(plugin).set(key, value);
            return this;
        }

        public <T extends ItemMeta> Builder editMeta(Consumer<T> action) {
            ItemWrapper.this.editMeta(action);
            return this;
        }

        public Builder meta(ItemMeta meta) {
            ItemWrapper.this.setMeta(meta);
            return this;
        }

        public ItemWrapper build() {
            return ItemWrapper.this;
        }
    }
}

