/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging.api.entity;

import com.aregcraft.reforging.api.DeltaPlugin;
import com.aregcraft.reforging.api.PersistentDataWrapper;
import com.aregcraft.reforging.api.entity.Entities;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Projectile;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class ProjectileBuilder {
    private final Map<String, Object> persistentData = new HashMap<String, Object>();
    private ProjectileSource source;
    private EntityType type;
    private Vector velocity;
    private boolean bounce;

    public ProjectileBuilder persistentData(String key, Object value) {
        this.persistentData.put(key, value);
        return this;
    }

    public ProjectileBuilder source(ProjectileSource source) {
        this.source = source;
        return this;
    }

    public ProjectileBuilder type(EntityType type) {
        this.type = type;
        return this;
    }

    public ProjectileBuilder velocity(Vector velocity) {
        this.velocity = velocity.clone();
        return this;
    }

    public ProjectileBuilder direction(Entity entity) {
        this.velocity.multiply(entity.getLocation().getDirection());
        return this;
    }

    public ProjectileBuilder bounce(boolean bounce) {
        this.bounce = bounce;
        return this;
    }

    public Projectile build(DeltaPlugin plugin) {
        Projectile projectile = this.build();
        PersistentDataWrapper.wrap(plugin, (PersistentDataHolder)projectile).setAll(this.persistentData);
        return projectile;
    }

    public Projectile build() {
        Projectile projectile = Entities.launchProjectile(this.source, this.type, this.velocity);
        projectile.setBounce(this.bounce);
        return projectile;
    }
}

