/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging.api.entity;

import com.aregcraft.reforging.api.item.ItemWrapper;
import java.util.Optional;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;

public class EquipmentWrapper {
    private final EntityEquipment equipment;

    private EquipmentWrapper(EntityEquipment equipment) {
        this.equipment = equipment;
    }

    public static EquipmentWrapper wrap(LivingEntity entity) {
        return EquipmentWrapper.wrap(entity.getEquipment());
    }

    public static EquipmentWrapper wrap(EntityEquipment equipment) {
        return new EquipmentWrapper(equipment);
    }

    public ItemWrapper getHelmet() {
        return ItemWrapper.wrap(this.equipment.getHelmet());
    }

    public void setHelmet(ItemWrapper helmet) {
        this.equipment.setHelmet(this.unwrapOrNull(helmet));
    }

    public ItemWrapper getChestplate() {
        return ItemWrapper.wrap(this.equipment.getChestplate());
    }

    public void setChestplate(ItemWrapper chestplate) {
        this.equipment.setChestplate(this.unwrapOrNull(chestplate));
    }

    public ItemWrapper getLeggings() {
        return ItemWrapper.wrap(this.equipment.getLeggings());
    }

    public void setLeggings(ItemWrapper leggings) {
        this.equipment.setLeggings(this.unwrapOrNull(leggings));
    }

    public ItemWrapper getBoots() {
        return ItemWrapper.wrap(this.equipment.getBoots());
    }

    public void setBoots(ItemWrapper boots) {
        this.equipment.setBoots(this.unwrapOrNull(boots));
    }

    public ItemWrapper getItemInMainHand() {
        return ItemWrapper.wrap(this.equipment.getItemInMainHand());
    }

    public void setItemInMainHand(ItemWrapper itemInMainHand) {
        this.equipment.setItemInMainHand(this.unwrapOrNull(itemInMainHand));
    }

    public ItemWrapper getItemInOffHand() {
        return ItemWrapper.wrap(this.equipment.getItemInOffHand());
    }

    public void setItemInOffHand(ItemWrapper itemInOffHand) {
        this.equipment.setItemInOffHand(this.unwrapOrNull(itemInOffHand));
    }

    private ItemStack unwrapOrNull(ItemWrapper item) {
        return Optional.ofNullable(item).map(ItemWrapper::unwrap).orElse(null);
    }
}

