/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging.api.entity;

import com.aregcraft.reforging.api.entity.selector.CombiningSelector;
import com.aregcraft.reforging.api.entity.selector.EntitySelector;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.util.BoundingBox;

public class EntityFinder {
    private final World world;
    private final BoundingBox boundingBox;

    private EntityFinder(World world, BoundingBox boundingBox) {
        this.world = world;
        this.boundingBox = boundingBox;
    }

    public static EntityFinder createAtBlock(Block block) {
        return new EntityFinder(block.getWorld(), BoundingBox.of((Block)block));
    }

    public static EntityFinder createAtLocation(Location location, double size) {
        return EntityFinder.createAtLocation(location, size, size, size);
    }

    public static EntityFinder createAtLocation(Location location, double x, double y, double z) {
        return new EntityFinder(location.getWorld(), BoundingBox.of((Location)location, (double)x, (double)y, (double)z));
    }

    public <T> List<T> find(Class<T> type, EntitySelector ... selectors) {
        return this.find(selectors).stream().filter(type::isInstance).map(type::cast).toList();
    }

    public List<Entity> find(EntitySelector ... selectors) {
        return this.find((EntitySelector)new CombiningSelector(selectors));
    }

    private List<Entity> find(EntitySelector selector) {
        return new ArrayList<Entity>(this.world.getNearbyEntities(this.boundingBox, (Predicate)selector));
    }
}

