/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging.api.entity;

import com.aregcraft.reforging.api.DeltaPlugin;
import com.aregcraft.reforging.api.FormattingContext;
import com.aregcraft.reforging.api.PersistentDataWrapper;
import com.aregcraft.reforging.api.entity.Entities;
import com.aregcraft.reforging.api.entity.EquipmentWrapper;
import com.aregcraft.reforging.api.item.ItemWrapper;
import com.aregcraft.reforging.api.util.CollectionMaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;

public class EntityBuilder {
    private final Map<Attribute, Collection<AttributeModifier>> attributeModifiers = new HashMap<Attribute, Collection<AttributeModifier>>();
    private final Map<String, Object> persistentData = new HashMap<String, Object>();
    private EntityType type;
    private String name = "";
    private double health;
    private boolean nameVisible;
    private boolean gravity = true;
    private boolean ai = true;
    private boolean invisible;
    private boolean glowing;
    private boolean canPickupItems;
    private boolean invulnerable;
    private boolean visualFire;
    private boolean adult = true;
    private ItemWrapper helmet;
    private ItemWrapper chestplate;
    private ItemWrapper leggings;
    private ItemWrapper boots;
    private ItemWrapper itemInMainHand;
    private ItemWrapper itemInOffHand;
    private transient FormattingContext nameFormattingContext = FormattingContext.DEFAULT;

    private EntityBuilder() {
    }

    public static EntityBuilder create() {
        return new EntityBuilder();
    }

    public static EntityBuilder createArmorStand() {
        return new EntityBuilder().type(EntityType.ARMOR_STAND).nameVisible(false).gravity(false).ai(false).invisible(true).invulnerable(true).persistentData("noninteractive", true);
    }

    public EntityBuilder attributeModifier(Attribute attribute, AttributeModifier modifier) {
        this.attributeModifiers.putIfAbsent(attribute, new ArrayList());
        this.attributeModifiers.get(attribute).add(modifier);
        return this;
    }

    public EntityBuilder persistentData(String key, Object value) {
        this.persistentData.put(key, value);
        return this;
    }

    public EntityBuilder type(EntityType type) {
        this.type = type;
        return this;
    }

    public EntityBuilder name(String name) {
        this.name = name;
        return this;
    }

    public EntityBuilder health(double health) {
        this.health = health;
        return this;
    }

    public EntityBuilder nameVisible(boolean nameVisible) {
        this.nameVisible = nameVisible;
        return this;
    }

    public EntityBuilder gravity(boolean gravity) {
        this.gravity = gravity;
        return this;
    }

    public EntityBuilder ai(boolean ai) {
        this.ai = ai;
        return this;
    }

    public EntityBuilder invisible(boolean invisible) {
        this.invisible = invisible;
        return this;
    }

    public EntityBuilder glowing(boolean glowing) {
        this.glowing = glowing;
        return this;
    }

    public EntityBuilder canPickupItems(boolean canPickupItems) {
        this.canPickupItems = canPickupItems;
        return this;
    }

    public EntityBuilder invulnerable(boolean invulnerable) {
        this.invulnerable = invulnerable;
        return this;
    }

    public EntityBuilder visualFire(boolean visualFire) {
        this.visualFire = visualFire;
        return this;
    }

    public EntityBuilder adult(boolean adult) {
        this.adult = adult;
        return this;
    }

    public EntityBuilder helmet(ItemWrapper helmet) {
        this.helmet = helmet;
        return this;
    }

    public EntityBuilder chestplate(ItemWrapper chestplate) {
        this.chestplate = chestplate;
        return this;
    }

    public EntityBuilder leggings(ItemWrapper leggings) {
        this.leggings = leggings;
        return this;
    }

    public EntityBuilder boots(ItemWrapper boots) {
        this.boots = boots;
        return this;
    }

    public EntityBuilder itemInMainHand(ItemWrapper itemInMainHand) {
        this.itemInMainHand = itemInMainHand;
        return this;
    }

    public EntityBuilder itemInOffHand(ItemWrapper itemInOffHand) {
        this.itemInOffHand = itemInOffHand;
        return this;
    }

    public EntityBuilder nameFormattingContext(FormattingContext nameFormattingContext) {
        this.nameFormattingContext = nameFormattingContext;
        return this;
    }

    public <T extends LivingEntity> T build(Location location, DeltaPlugin plugin) {
        return (T)this.build((LivingEntity)Entities.spawnEntity(this.type, location), plugin);
    }

    public <T extends LivingEntity> T build(Location location) {
        return (T)this.build((LivingEntity)Entities.spawnEntity(this.type, location));
    }

    public <T extends LivingEntity> T build(T entity, DeltaPlugin plugin) {
        PersistentDataWrapper.wrap(plugin, entity).setAll(this.persistentData);
        return this.build(entity);
    }

    public <T extends LivingEntity> T build(T entity) {
        CollectionMaps.forEach(this.attributeModifiers, (attribute, modifier) -> Objects.requireNonNull(entity.getAttribute(attribute)).addModifier(modifier));
        entity.setHealth(this.health > 0.0 ? this.health : Objects.requireNonNull(entity.getAttribute(Attribute.GENERIC_MAX_HEALTH)).getValue());
        entity.setCustomName(this.nameFormattingContext.format(this.name));
        entity.setCustomNameVisible(this.nameVisible);
        entity.setGravity(this.gravity);
        entity.setAI(this.ai);
        entity.setInvisible(this.invisible);
        entity.setGlowing(this.glowing);
        entity.setCanPickupItems(this.canPickupItems);
        entity.setInvulnerable(this.invulnerable);
        entity.setVisualFire(this.visualFire);
        if (entity instanceof Ageable) {
            Ageable ageable = (Ageable)entity;
            if (this.adult) {
                ageable.setAdult();
            } else {
                ageable.setBaby();
            }
        }
        EquipmentWrapper equipment = EquipmentWrapper.wrap(entity);
        equipment.setHelmet(this.helmet);
        equipment.setChestplate(this.chestplate);
        equipment.setLeggings(this.leggings);
        equipment.setBoots(this.boots);
        equipment.setItemInMainHand(this.itemInMainHand);
        equipment.setItemInOffHand(this.itemInOffHand);
        return entity;
    }
}

