/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging.api.entity;

import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class Entities {
    private Entities() {
    }

    public static <T extends Entity> T spawnEntity(EntityType type, Location location) {
        return (T)Objects.requireNonNull(location.getWorld()).spawnEntity(location, type);
    }

    public static void spawnParticle(Particle particle, Location location) {
        Objects.requireNonNull(location.getWorld()).spawnParticle(particle, location, 0);
    }

    public static Projectile launchProjectile(ProjectileSource source, EntityType type, Vector velocity) {
        return source.launchProjectile(Entities.getProjectileClass(type), velocity);
    }

    public static Projectile launchProjectile(ProjectileSource source, EntityType type) {
        return source.launchProjectile(Entities.getProjectileClass(type));
    }

    private static Class<? extends Projectile> getProjectileClass(EntityType type) {
        return type.getEntityClass();
    }

    public static void addPotionEffect(LivingEntity entity, PotionEffectType type, int amplifier, int duration, boolean hideParticles) {
        entity.addPotionEffect(new PotionEffect(type, amplifier, duration, !hideParticles, !hideParticles));
    }
}

