/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging.api.block.custom;

import com.aregcraft.reforging.api.DeltaPlugin;
import com.aregcraft.reforging.api.block.BlockWrapper;
import com.aregcraft.reforging.api.block.custom.CustomBlock;
import com.aregcraft.reforging.api.item.ItemWrapper;
import com.aregcraft.reforging.api.util.Classes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.inventory.EquipmentSlot;

public class CustomBlockWrapper
implements Listener {
    private final Map<Location, CustomBlock> customBlocks = new HashMap<Location, CustomBlock>();
    private final String id;
    private final Class<?> type;
    private final DeltaPlugin plugin;

    public CustomBlockWrapper(String id, Class<?> type, DeltaPlugin plugin) {
        this.id = id;
        this.type = type;
        this.plugin = plugin;
        plugin.registerListener(this);
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        if (!ItemWrapper.wrap(event.getItemInHand()).getPersistentData(this.plugin).check("id", this.id)) {
            return;
        }
        Block block = event.getBlock();
        BlockWrapper.wrap(block, this.plugin).getPersistentData().set("id", this.id);
        this.getCustomBlock(block).onPlace(event);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        if (event.isCancelled() || this.isNotThisBlock(block)) {
            return;
        }
        CustomBlock customBlock = this.getCustomBlock(block);
        customBlock.onBreak(event);
        if (!event.isDropItems() || event.getPlayer().getGameMode() == GameMode.CREATIVE) {
            return;
        }
        event.setDropItems(false);
        customBlock.getItem().dropNaturally(block.getLocation());
    }

    @EventHandler
    public void onBlockExplode(BlockExplodeEvent event) {
        this.explodeCustomBlocks(event.blockList());
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent event) {
        this.explodeCustomBlocks(event.blockList());
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        if (block == null || event.getHand() != EquipmentSlot.HAND || this.isNotThisBlock(block)) {
            return;
        }
        CustomBlock customBlock = this.getCustomBlock(block);
        customBlock.onClick(event);
        if (event.getAction() == Action.LEFT_CLICK_BLOCK) {
            customBlock.onLeftClick(event);
            return;
        }
        customBlock.onRightClick(event);
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        Chunk chunk = event.getChunk();
        chunk.getPersistentDataContainer().getKeys().stream().map(NamespacedKey::getKey).filter(it -> it.startsWith("block_")).map(it -> this.getBlockAt((String)it, chunk)).forEach(this::loadCustomBlock);
    }

    private Block getBlockAt(String key, Chunk chunk) {
        String[] xyz = key.split("_");
        return chunk.getBlock(Integer.parseInt(xyz[1]), Integer.parseInt(xyz[2]), Integer.parseInt(xyz[3]));
    }

    private void explodeCustomBlocks(List<Block> blocks) {
        blocks.removeIf(it -> {
            if (this.isNotThisBlock((Block)it)) {
                return false;
            }
            it.setType(Material.AIR);
            this.getCustomBlock((Block)it).getItem().dropNaturally(it.getLocation());
            return true;
        });
    }

    private CustomBlock getCustomBlock(Block block) {
        Location location = block.getLocation();
        if (!this.customBlocks.containsKey(location)) {
            this.loadCustomBlock(block);
        }
        return this.customBlocks.get(location);
    }

    private void loadCustomBlock(Block block) {
        CustomBlock customBlock = (CustomBlock)Classes.newUncheckedInstanceWithPlugin(this.type, this.plugin);
        this.customBlocks.put(block.getLocation(), customBlock);
        customBlock.onEnable(block);
        this.plugin.registerDisableHook(() -> customBlock.onDisable(block));
    }

    private boolean isNotThisBlock(Block block) {
        return !CustomBlock.check(block, this.id, this.plugin);
    }
}

