/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging.api.block;

import com.aregcraft.reforging.api.DeltaPlugin;
import com.aregcraft.reforging.api.PersistentDataWrapper;
import com.aregcraft.reforging.api.RegisteredListener;
import com.aregcraft.reforging.api.block.BlockWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.block.BlockPistonEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.persistence.PersistentDataHolder;

@RegisteredListener
public class BlockWrapperListener
implements Listener {
    private DeltaPlugin plugin;

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!event.isCancelled()) {
            this.remove(event.getBlock());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        Entity entity = event.getEntity();
        Block block = event.getBlock();
        if (entity.getType() != EntityType.FALLING_BLOCK) {
            this.remove(block);
            return;
        }
        PersistentDataWrapper persistentData = PersistentDataWrapper.wrap(this.plugin, (PersistentDataHolder)entity);
        Material to = event.getTo();
        if (to == Material.AIR && BlockWrapper.wrap(block, this.plugin).hasPersistentData()) {
            persistentData.set("from", block.getLocation());
            return;
        }
        if (to != Material.AIR && persistentData.has("from", Location.class)) {
            this.move(persistentData.get("from", Location.class).getBlock(), block);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockExplode(BlockExplodeEvent event) {
        event.blockList().forEach(this::remove);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityExplode(EntityExplodeEvent event) {
        event.blockList().forEach(this::remove);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockBurn(BlockBurnEvent event) {
        this.remove(event.getBlock());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockFade(BlockFadeEvent event) {
        this.remove(event.getBlock());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockFertilize(BlockFertilizeEvent event) {
        event.getBlocks().stream().map(BlockState::getBlock).forEach(this::remove);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onStructureGrow(StructureGrowEvent event) {
        event.getBlocks().stream().map(BlockState::getBlock).forEach(this::remove);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        this.moveAll((BlockPistonEvent)event, new ArrayList<Block>(event.getBlocks()));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockPistonRetract(BlockPistonRetractEvent event) {
        this.moveAll((BlockPistonEvent)event, new ArrayList<Block>(event.getBlocks()));
    }

    private void moveAll(BlockPistonEvent event, List<Block> blocks) {
        Collections.reverse(blocks);
        blocks.stream().filter(it -> BlockWrapper.wrap(it, this.plugin).hasPersistentData()).forEach(it -> this.move((Block)it, it.getRelative(event.getDirection())));
    }

    private void move(Block from, Block to) {
        BlockWrapper.wrap(to, this.plugin).setPersistentData(BlockWrapper.wrap(from, this.plugin).getPersistentData());
        this.remove(from);
    }

    private void remove(Block block) {
        BlockWrapper.wrap(block, this.plugin).remove();
    }
}

