/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging.api.block;

import com.aregcraft.reforging.api.DeltaPlugin;
import com.aregcraft.reforging.api.PersistentDataWrapper;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class BlockWrapper {
    private static final String KEY_TEMPLATE = "block_%d_%d_%d";
    private final DeltaPlugin plugin;
    private final PersistentDataContainer chunkDataContainer;
    private final NamespacedKey key;

    public static BlockWrapper wrap(Block block, DeltaPlugin plugin) {
        return new BlockWrapper(plugin, block);
    }

    public static BlockWrapper wrap(BlockState blockState, DeltaPlugin plugin) {
        return BlockWrapper.wrap(blockState.getBlock(), plugin);
    }

    public static BlockWrapper wrap(Location location, DeltaPlugin plugin) {
        return BlockWrapper.wrap(location.getBlock(), plugin);
    }

    private BlockWrapper(DeltaPlugin plugin, Block block) {
        this.plugin = plugin;
        this.chunkDataContainer = block.getChunk().getPersistentDataContainer();
        this.key = new NamespacedKey((Plugin)plugin, KEY_TEMPLATE.formatted(block.getX() & 0xF, block.getY(), block.getZ() & 0xF));
    }

    public boolean hasPersistentData() {
        return this.chunkDataContainer.has(this.key, PersistentDataType.TAG_CONTAINER);
    }

    public PersistentDataWrapper getPersistentData() {
        return PersistentDataWrapper.wrap(this.plugin, this.getDataContainer(), this::setDataContainer);
    }

    public void setPersistentData(PersistentDataWrapper persistentData) {
        this.setDataContainer(persistentData.unwrap());
    }

    public void remove() {
        this.chunkDataContainer.remove(this.key);
    }

    private PersistentDataContainer getDataContainer() {
        return (PersistentDataContainer)this.chunkDataContainer.getOrDefault(this.key, PersistentDataType.TAG_CONTAINER, (Object)this.newDataContainer());
    }

    private PersistentDataContainer newDataContainer() {
        return this.chunkDataContainer.getAdapterContext().newPersistentDataContainer();
    }

    private void setDataContainer(PersistentDataContainer persistentDataContainer) {
        this.chunkDataContainer.set(this.key, PersistentDataType.TAG_CONTAINER, (Object)persistentDataContainer);
    }
}

