/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging.api;

import com.aregcraft.reforging.api.DeltaPlugin;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.bukkit.NamespacedKey;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class PersistentDataWrapper {
    private final DeltaPlugin plugin;
    private final PersistentDataContainer container;
    private final Consumer<PersistentDataContainer> action;

    private PersistentDataWrapper(DeltaPlugin plugin, PersistentDataContainer container, Consumer<PersistentDataContainer> action) {
        this.plugin = plugin;
        this.container = container;
        this.action = action;
    }

    public static PersistentDataWrapper wrap(DeltaPlugin plugin, PersistentDataContainer container, Consumer<PersistentDataContainer> action) {
        return new PersistentDataWrapper(plugin, container, action);
    }

    public static PersistentDataWrapper wrap(DeltaPlugin plugin, PersistentDataHolder holder) {
        return PersistentDataWrapper.wrap(plugin, holder.getPersistentDataContainer());
    }

    public static PersistentDataWrapper wrap(DeltaPlugin plugin, PersistentDataHolder holder, Consumer<PersistentDataContainer> action) {
        return PersistentDataWrapper.wrap(plugin, holder.getPersistentDataContainer(), action);
    }

    public static PersistentDataWrapper wrap(DeltaPlugin plugin, PersistentDataContainer container) {
        return PersistentDataWrapper.wrap(plugin, container, (PersistentDataContainer it) -> {});
    }

    public boolean has(String key, Class<?> type) {
        return this.container.has(new NamespacedKey((Plugin)this.plugin, key), new JsonPersistentDataType(type));
    }

    public <T> T get(String key, Class<T> type) {
        return (T)this.container.get(new NamespacedKey((Plugin)this.plugin, key), new JsonPersistentDataType<T>(type));
    }

    public <T> T getOrElse(String key, T other) {
        Class<?> type = other.getClass();
        return (T)(this.has(key, type) ? this.get(key, type) : other);
    }

    public boolean check(String key, Object value) {
        return Objects.equals(this.get(key, value.getClass()), value);
    }

    public void setIfAbsent(String key, Object value) {
        if (!this.has(key, value.getClass())) {
            this.set(key, value);
        }
    }

    public void set(String key, Object value) {
        NamespacedKey namespacedKey = new NamespacedKey((Plugin)this.plugin, key);
        if (value == null) {
            this.container.remove(namespacedKey);
        } else {
            this.container.set(namespacedKey, this.getPersistentDataType(value), value);
        }
        this.action.accept(this.container);
    }

    public void setAll(Map<String, Object> map) {
        map.forEach(this::set);
    }

    public void remove(String key) {
        this.set(key, null);
    }

    private <T> PersistentDataType<String, T> getPersistentDataType(Object value) {
        return new JsonPersistentDataType(value.getClass());
    }

    public PersistentDataContainer unwrap() {
        return this.container;
    }

    private class JsonPersistentDataType<T>
    implements PersistentDataType<String, T> {
        private final Class<T> complexType;

        private JsonPersistentDataType(Class<T> complexType) {
            this.complexType = complexType;
        }

        public Class<String> getPrimitiveType() {
            return String.class;
        }

        public Class<T> getComplexType() {
            return this.complexType;
        }

        public String toPrimitive(T complex, PersistentDataAdapterContext context) {
            return PersistentDataWrapper.this.plugin.getGson().toJson(complex);
        }

        public T fromPrimitive(String primitive, PersistentDataAdapterContext context) {
            return (T)PersistentDataWrapper.this.plugin.getGson().fromJson(primitive, this.complexType);
        }
    }
}

