/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging.api;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;

public class FormattingContext {
    public static final FormattingContext DEFAULT = FormattingContext.builder().build();
    private static final Pattern FORMAT_PATTERN = Pattern.compile("%(#[a-fA-F0-9]{6}|[a-zA-Z_]+)%");
    private static final Pattern UNFORMAT_CHAR_PATTERN = Pattern.compile("\u00a7([a-fk-or0-9])");
    private static final Pattern UNFORMAT_HEX_PATTERN = Pattern.compile("\u00a7x((\u00a7[A-F0-9]){6})");
    private final Map<String, Object> placeholders;
    private final Map<Class<?>, Function<Object, Object>> formatters;

    private FormattingContext(Map<String, Object> placeholders, Map<Class<?>, Function<Object, Object>> formatters) {
        this.placeholders = placeholders;
        this.formatters = formatters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String format(String string) {
        return FORMAT_PATTERN.matcher(string).replaceAll(it -> {
            String group = it.group(1);
            try {
                return ChatColor.of((String)group).toString();
            }
            catch (IllegalArgumentException e) {
                return this.formatPlaceholder(group);
            }
        });
    }

    public String unformat(String string) {
        return this.unformatChar(this.unformatHex(string));
    }

    public boolean isDisplayable(String string) {
        Matcher matcher = FORMAT_PATTERN.matcher(string);
        while (matcher.find()) {
            String group = matcher.group(1);
            if (this.isColor(group) || this.placeholders.containsKey(group)) continue;
            return false;
        }
        return true;
    }

    private boolean isColor(String string) {
        try {
            ChatColor.of((String)string);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    private String unformatChar(String string) {
        return UNFORMAT_CHAR_PATTERN.matcher(string).replaceAll(it -> "%" + ChatColor.getByChar((char)it.group(1).charAt(0)).getName() + "%");
    }

    private String unformatHex(String string) {
        return UNFORMAT_HEX_PATTERN.matcher(string).replaceAll(it -> "%#" + this.stripColorChars(it.group(1)).toLowerCase() + "%");
    }

    private String stripColorChars(String string) {
        return string.replaceAll(String.valueOf('\u00a7'), "");
    }

    private String formatPlaceholder(String key) {
        Object value = this.placeholders.get(key);
        if (value == null) {
            return "%" + key + "%";
        }
        return this.format(this.getFormatter(value.getClass()).apply(value).toString());
    }

    private Function<Object, Object> getFormatter(Class<?> key) {
        return this.formatters.getOrDefault(key, Function.identity());
    }

    public static class Builder {
        private final Map<String, Object> placeholders = new HashMap<String, Object>();
        private final Map<Class<?>, Function<Object, Object>> formatters = new HashMap();

        private Builder() {
        }

        public Builder placeholder(String key, Object value) {
            this.placeholders.put(key, value);
            return this;
        }

        public Builder formatter(Class<?> key, Function<Object, Object> value) {
            this.formatters.put(key, value);
            return this;
        }

        public FormattingContext build() {
            return new FormattingContext(this.placeholders, this.formatters);
        }
    }
}

