/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging.api;

import com.aregcraft.reforging.api.RegisteredListener;
import com.aregcraft.reforging.api.block.custom.CustomBlockWrapper;
import com.aregcraft.reforging.api.block.custom.RegisteredCustomBlock;
import com.aregcraft.reforging.api.command.RegisteredCommand;
import com.aregcraft.reforging.api.json.GsonFactory;
import com.aregcraft.reforging.api.scheduler.AsynchronousScheduler;
import com.aregcraft.reforging.api.scheduler.Scheduler;
import com.aregcraft.reforging.api.scheduler.SynchronousScheduler;
import com.aregcraft.reforging.api.util.Classes;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.reflections.Reflections;

public class DeltaPlugin
extends JavaPlugin {
    private final Reflections reflections = new Reflections(DeltaPlugin.class, ((Object)((Object)this)).getClass());
    private final Gson gson = new GsonFactory(this).create();
    private final List<Runnable> disableHooks = new ArrayList<Runnable>();
    private final List<Listener> registeredListeners = new ArrayList<Listener>();
    private final Scheduler synchronousScheduler = new SynchronousScheduler(this);
    private final Scheduler asynchronousScheduler = new AsynchronousScheduler(this);

    public void onEnable() {
        this.registerListeners();
        this.registerCommands();
        this.registerCustomBlocks();
    }

    public void onDisable() {
        this.disableHooks.forEach(Runnable::run);
    }

    public void registerDisableHook(Runnable hook) {
        this.disableHooks.add(hook);
    }

    protected void registerListeners() {
        this.reflections.getTypesAnnotatedWith(RegisteredListener.class).forEach(this::registerListener);
        this.registeredListeners.forEach(this::registerListener);
    }

    public void registerListener(Class<?> type) {
        this.registerListener((Listener)Classes.newUncheckedInstanceWithPlugin(type, this));
    }

    public void registerListener(Listener listener) {
        if (this.isEnabled()) {
            Bukkit.getPluginManager().registerEvents(listener, (Plugin)this);
            return;
        }
        this.registeredListeners.add(listener);
    }

    public void unregisterListener(Listener listener) {
        HandlerList.unregisterAll((Listener)listener);
    }

    protected void registerCommands() {
        this.reflections.getTypesAnnotatedWith(RegisteredCommand.class).forEach(this::registerCommand);
    }

    private void registerCommand(Class<?> type) {
        this.registerCommand(type.getAnnotation(RegisteredCommand.class).value(), (TabExecutor)Classes.newUncheckedInstanceWithPlugin(type, this));
    }

    public void registerCommand(String name, TabExecutor tabExecutor) {
        PluginCommand command = Objects.requireNonNull(this.getCommand(name));
        command.setExecutor((CommandExecutor)tabExecutor);
        command.setTabCompleter((TabCompleter)tabExecutor);
    }

    protected void registerCustomBlocks() {
        this.reflections.getTypesAnnotatedWith(RegisteredCustomBlock.class).forEach(this::registerCustomBlock);
    }

    private void registerCustomBlock(Class<?> type) {
        new CustomBlockWrapper(type.getAnnotation(RegisteredCustomBlock.class).value(), type, this);
    }

    public Reflections getReflections() {
        return this.reflections;
    }

    public Gson getGson() {
        return this.gson;
    }

    public Scheduler getSynchronousScheduler() {
        return this.synchronousScheduler;
    }

    public Scheduler getAsynchronousScheduler() {
        return this.asynchronousScheduler;
    }
}

