/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging.api;

import com.aregcraft.reforging.api.item.ItemWrapper;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.attribute.Attributable;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.EquipmentSlot;

public class AttributeModifierBuilder {
    private final Modifiable modifiable;
    private Attribute attribute;
    private UUID uuid = UUID.randomUUID();
    private String name;
    private double amount;
    private AttributeModifier.Operation operation = AttributeModifier.Operation.ADD_NUMBER;
    private EquipmentSlot slot;

    public static AttributeModifierBuilder forItem(ItemWrapper item) {
        return new AttributeModifierBuilder(new ItemWrapperModifiable(item));
    }

    public static AttributeModifierBuilder forAttributable(Attributable attributable) {
        return new AttributeModifierBuilder(new AttributableModifiable(attributable));
    }

    private AttributeModifierBuilder(Modifiable modifiable) {
        this.modifiable = modifiable;
    }

    public AttributeModifierBuilder attribute(Attribute attribute) {
        this.attribute = attribute;
        this.name = Optional.ofNullable(this.name).orElseGet(() -> attribute.name());
        return this;
    }

    public AttributeModifierBuilder uuid(UUID uuid) {
        this.uuid = uuid;
        return this;
    }

    public AttributeModifierBuilder name(String name) {
        this.name = name;
        return this;
    }

    public AttributeModifierBuilder amount(double amount) {
        this.amount = amount;
        return this;
    }

    public AttributeModifierBuilder operation(AttributeModifier.Operation operation) {
        this.operation = operation;
        return this;
    }

    public AttributeModifierBuilder slot(EquipmentSlot slot) {
        this.slot = slot;
        return this;
    }

    public void add() {
        this.modifiable.addAttributeModifier(this.attribute, new AttributeModifier(this.uuid, this.name, this.amount, this.operation, this.slot));
    }

    public void remove() {
        this.modifiable.removeAttributeModifier(this.attribute, new AttributeModifier(this.uuid, this.name, this.amount, this.operation, this.slot));
    }

    private static class ItemWrapperModifiable
    implements Modifiable {
        private final ItemWrapper item;

        private ItemWrapperModifiable(ItemWrapper item) {
            this.item = item;
        }

        @Override
        public void addAttributeModifier(Attribute attribute, AttributeModifier modifier) {
            this.item.addAttributeModifier(attribute, modifier);
        }

        @Override
        public void removeAttributeModifier(Attribute attribute, AttributeModifier modifier) {
            this.item.removeAttributeModifier(attribute, modifier);
        }
    }

    private static interface Modifiable {
        public void addAttributeModifier(Attribute var1, AttributeModifier var2);

        public void removeAttributeModifier(Attribute var1, AttributeModifier var2);
    }

    private static class AttributableModifiable
    implements Modifiable {
        private final Attributable attributable;

        private AttributableModifiable(Attributable attributable) {
            this.attributable = attributable;
        }

        @Override
        public void addAttributeModifier(Attribute attribute, AttributeModifier modifier) {
            Objects.requireNonNull(this.attributable.getAttribute(attribute)).addModifier(modifier);
        }

        @Override
        public void removeAttributeModifier(Attribute attribute, AttributeModifier modifier) {
            Objects.requireNonNull(this.attributable.getAttribute(attribute)).removeModifier(modifier);
        }
    }
}

