/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging.ability;

import com.aregcraft.reforging.Reforging;
import com.aregcraft.reforging.ability.Ability;
import com.aregcraft.reforging.ability.Price;
import com.aregcraft.reforging.api.DeltaPlugin;
import com.aregcraft.reforging.api.entity.EntityBuilder;
import com.aregcraft.reforging.api.entity.EntityFinder;
import com.aregcraft.reforging.api.entity.EquipmentWrapper;
import com.aregcraft.reforging.api.entity.selector.ExcludingSelector;
import com.aregcraft.reforging.api.item.ItemWrapper;
import com.aregcraft.reforging.meta.ProcessedAbility;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

@ProcessedAbility
public class ThrowAbility
extends Ability {
    private Price price;
    private long cooldown;
    private long duration;
    private Vector velocity;
    private double damageMultiplier;
    private transient Reforging plugin;

    @Override
    public void activate(Player player) {
        if (this.cooldownManager.isOnCooldown(player, this.cooldown, this.plugin)) {
            return;
        }
        this.cooldownManager.putOnCooldown(player, this.plugin);
        this.price.deduct(player);
        Location location = player.getLocation();
        Vector direction = location.getDirection();
        location.add(direction.getCrossProduct(new Vector(0, 1, 0)).normalize().multiply(0.25));
        ArmorStand armorStand = (ArmorStand)EntityBuilder.createArmorStand().itemInMainHand(EquipmentWrapper.wrap((LivingEntity)player).getItemInMainHand()).build(location, (DeltaPlugin)this.plugin);
        armorStand.setRightArmPose(this.getArmorStandArmPose(location));
        this.plugin.getSynchronousScheduler().scheduleRepeatingTask((self, i) -> this.update(armorStand, player, direction, (BukkitRunnable)self), 0L, 1L, this.duration);
    }

    private void update(ArmorStand armorStand, Player player, Vector direction, BukkitRunnable task) {
        Location location = armorStand.getLocation().add(direction.clone().multiply(this.velocity));
        armorStand.teleport(location);
        EntityFinder.createAtLocation(location.add(0.0, 1.5, 0.0), 0.5).find(LivingEntity.class, new ExcludingSelector((Entity)player), new ExcludingSelector((Entity)armorStand)).forEach(it -> this.damageEntity((LivingEntity)it, EquipmentWrapper.wrap((LivingEntity)player).getItemInMainHand(), player));
        if (location.getBlock().getType().isSolid()) {
            task.cancel();
        }
        if (task.isCancelled()) {
            armorStand.remove();
        }
    }

    private void damageEntity(LivingEntity entity, ItemWrapper item, Player player) {
        entity.damage(this.damageMultiplier * item.getAttributeValue(Attribute.GENERIC_ATTACK_DAMAGE), (Entity)player);
    }

    private EulerAngle getArmorStandArmPose(Location location) {
        return new EulerAngle(6.1, Math.toRadians(location.getPitch()), 4.71238898038469);
    }
}

