/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging.ability;

import com.aregcraft.reforging.Reforging;
import com.aregcraft.reforging.ability.Ability;
import com.aregcraft.reforging.ability.Price;
import com.aregcraft.reforging.meta.ProcessedAbility;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

@ProcessedAbility
public class TeleportAbility
extends Ability {
    private Price price;
    private long cooldown;
    private int distance;
    private transient Reforging plugin;

    @Override
    public void activate(Player player) {
        if (this.cooldownManager.isOnCooldown(player, this.cooldown, this.plugin)) {
            return;
        }
        this.cooldownManager.putOnCooldown(player, this.plugin);
        this.price.deduct(player);
        Location location = player.getLocation();
        Vector direction = location.getDirection();
        direction.setY(Math.max(direction.getY(), 0.0));
        location.add(direction.multiply(this.distance));
        while (this.isBlockSolid(location) || this.isBlockSolid(location.clone().add(0.0, 1.0, 0.0))) {
            if (player.getLocation().add(direction).equals((Object)location)) {
                return;
            }
            location.subtract(direction);
        }
        location.setX((double)location.getBlockX());
        location.setY((double)location.getBlockY());
        location.setZ((double)location.getBlockZ());
        player.teleport(location.add(0.5, 0.0, 0.5));
    }

    private boolean isBlockSolid(Location location) {
        return location.getBlock().getType().isSolid();
    }
}

