/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging.ability;

import com.aregcraft.reforging.Reforging;
import com.aregcraft.reforging.ability.Ability;
import com.aregcraft.reforging.ability.Price;
import com.aregcraft.reforging.api.DeltaPlugin;
import com.aregcraft.reforging.api.PersistentDataWrapper;
import com.aregcraft.reforging.function.Function2;
import com.aregcraft.reforging.meta.ProcessedAbility;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.persistence.PersistentDataHolder;

@ProcessedAbility
public class StormAbility
extends Ability
implements Listener {
    private static final long INVULNERABILITY_DURATION = 20L;
    private Price price;
    private long cooldown;
    private Function2 function;
    private transient Reforging plugin;

    @Override
    public void activate(Player player) {
        if (this.cooldownManager.isOnCooldown(player, this.cooldown, this.plugin)) {
            return;
        }
        this.cooldownManager.putOnCooldown(player, this.plugin);
        PersistentDataWrapper persistentData = PersistentDataWrapper.wrap((DeltaPlugin)this.plugin, (PersistentDataHolder)player);
        persistentData.set("storm", true);
        this.plugin.getSynchronousScheduler().scheduleDelayedTask(() -> persistentData.remove("storm"), 20L);
        this.price.deduct(player);
        this.function.evaluate(it -> player.getWorld().strikeLightning(player.getLocation().add(it)));
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        if (event.getCause() == EntityDamageEvent.DamageCause.LIGHTNING && PersistentDataWrapper.wrap((DeltaPlugin)this.plugin, (PersistentDataHolder)event.getEntity()).check("storm", true)) {
            event.setDamage(0.0);
        }
    }
}

