/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging.ability;

import com.aregcraft.reforging.Reforging;
import com.aregcraft.reforging.ability.Ability;
import com.aregcraft.reforging.ability.Price;
import com.aregcraft.reforging.api.DeltaPlugin;
import com.aregcraft.reforging.api.PersistentDataWrapper;
import com.aregcraft.reforging.api.entity.Entities;
import com.aregcraft.reforging.function.Function3;
import com.aregcraft.reforging.meta.ProcessedAbility;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.persistence.PersistentDataHolder;

@ProcessedAbility
public class ShieldAbility
extends Ability
implements Listener {
    private Price price;
    private long cooldown;
    private long duration;
    private Function3 function;
    private Particle particle;
    private boolean disableAttack;
    private transient Reforging plugin;

    @Override
    public void activate(Player player) {
        if (this.cooldownManager.isOnCooldown(player, this.cooldown, this.plugin)) {
            return;
        }
        this.cooldownManager.putOnCooldown(player, this.plugin);
        PersistentDataWrapper persistentData = PersistentDataWrapper.wrap((DeltaPlugin)this.plugin, (PersistentDataHolder)player);
        persistentData.set("shield", true);
        this.plugin.getSynchronousScheduler().scheduleDelayedTask(() -> persistentData.remove("shield"), this.duration);
        this.price.deduct(player);
        this.plugin.getSynchronousScheduler().scheduleRepeatingTask(() -> this.update(player), 0L, 1L, this.duration);
    }

    private void update(Player player) {
        this.function.evaluate(it -> Entities.spawnParticle(this.particle, player.getLocation().add(it)));
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        event.setCancelled(PersistentDataWrapper.wrap((DeltaPlugin)this.plugin, (PersistentDataHolder)event.getEntity()).check("shield", true) || this.disableAttack && PersistentDataWrapper.wrap((DeltaPlugin)this.plugin, (PersistentDataHolder)event.getDamager()).check("shield", true));
    }
}

