/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging.ability;

import com.aregcraft.reforging.Reforging;
import com.aregcraft.reforging.ability.Ability;
import com.aregcraft.reforging.ability.Price;
import com.aregcraft.reforging.api.entity.Entities;
import com.aregcraft.reforging.api.entity.EntityFinder;
import com.aregcraft.reforging.api.entity.selector.ExcludingSelector;
import com.aregcraft.reforging.function.Function2;
import com.aregcraft.reforging.meta.ProcessedAbility;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

@ProcessedAbility
public class SeismicWaveAbility
extends Ability {
    private Price price;
    private long cooldown;
    private Function2 function;
    private Particle particle;
    private Vector knockback;
    private double height;
    private double damage;
    private double range;
    private transient Reforging plugin;

    @Override
    public void activate(Player player) {
        if (this.cooldownManager.isOnCooldown(player, this.cooldown, this.plugin)) {
            return;
        }
        this.cooldownManager.putOnCooldown(player, this.plugin);
        this.price.deduct(player);
        Location location = player.getLocation();
        EntityFinder.createAtLocation(location, this.range).find(LivingEntity.class, new ExcludingSelector((Entity)player)).forEach(it -> this.damageAndKnockbackEntity((LivingEntity)it, player));
        this.function.evaluate(it -> Entities.spawnParticle(this.particle, location.clone().add(it)));
    }

    private void damageAndKnockbackEntity(LivingEntity entity, Player player) {
        entity.damage(this.damage, (Entity)player);
        Vector velocity = entity.getLocation().subtract(player.getLocation()).toVector();
        if (velocity.length() != 0.0) {
            velocity.normalize().multiply(this.knockback);
        }
        entity.setVelocity(velocity.setY(this.height));
    }
}

