/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging.ability;

import com.aregcraft.reforging.Reforging;
import com.aregcraft.reforging.ability.Ability;
import com.aregcraft.reforging.ability.Price;
import com.aregcraft.reforging.api.DeltaPlugin;
import com.aregcraft.reforging.api.PersistentDataWrapper;
import com.aregcraft.reforging.api.entity.Entities;
import com.aregcraft.reforging.meta.ProcessedAbility;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.potion.PotionEffectType;

@ProcessedAbility
public class RageAbility
extends Ability
implements Listener {
    private Price price;
    private long cooldown;
    private int duration;
    private int amplifier;
    private double multiplier;
    private transient Reforging plugin;

    @Override
    public void activate(Player player) {
        if (this.cooldownManager.isOnCooldown(player, this.cooldown, this.plugin)) {
            return;
        }
        this.cooldownManager.putOnCooldown(player, this.plugin);
        PersistentDataWrapper persistentData = PersistentDataWrapper.wrap((DeltaPlugin)this.plugin, (PersistentDataHolder)player);
        persistentData.set("rage", true);
        this.plugin.getSynchronousScheduler().scheduleDelayedTask(() -> persistentData.remove("rage"), (long)this.duration);
        this.price.deduct(player);
        Entities.addPotionEffect((LivingEntity)player, PotionEffectType.INCREASE_DAMAGE, this.duration, this.amplifier, true);
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Player player;
        Entity entity = event.getDamager();
        if (entity instanceof Player && PersistentDataWrapper.wrap((DeltaPlugin)this.plugin, (PersistentDataHolder)(player = (Player)entity)).check("rage", true)) {
            player.damage(this.multiplier * event.getDamage());
        }
    }
}

