/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging.ability;

import com.aregcraft.reforging.Reforging;
import com.aregcraft.reforging.ability.Ability;
import com.aregcraft.reforging.ability.Price;
import com.aregcraft.reforging.api.entity.ProjectileBuilder;
import com.aregcraft.reforging.api.item.ItemWrapper;
import com.aregcraft.reforging.meta.ProcessedAbility;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

@ProcessedAbility
public class PotionAbility
extends Ability {
    private Price price;
    private long cooldown;
    private PotionEffectType type;
    private int duration;
    private int amplifier;
    private boolean hideParticles;
    private Vector velocity;
    private transient Reforging plugin;

    @Override
    public void activate(Player player) {
        if (this.cooldownManager.isOnCooldown(player, this.cooldown, this.plugin)) {
            return;
        }
        this.cooldownManager.putOnCooldown(player, this.plugin);
        this.price.deduct(player);
        this.launchProjectile(player).setItem(ItemWrapper.builder().material(Material.SPLASH_POTION).editMeta(it -> it.addCustomEffect(this.getPotionEffect(), true)).build().unwrap());
    }

    private ThrownPotion launchProjectile(Player player) {
        return (ThrownPotion)new ProjectileBuilder().source((ProjectileSource)player).type(EntityType.SPLASH_POTION).velocity(this.velocity).direction((Entity)player).build();
    }

    private PotionEffect getPotionEffect() {
        return new PotionEffect(this.type, this.duration, this.amplifier, !this.hideParticles, !this.hideParticles);
    }
}

