/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging.ability;

import com.aregcraft.reforging.Reforging;
import com.aregcraft.reforging.ability.Ability;
import com.aregcraft.reforging.ability.Price;
import com.aregcraft.reforging.api.DeltaPlugin;
import com.aregcraft.reforging.api.FormattingContext;
import com.aregcraft.reforging.api.PersistentDataWrapper;
import com.aregcraft.reforging.api.entity.EntityBuilder;
import com.aregcraft.reforging.meta.ProcessedAbility;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.persistence.PersistentDataHolder;

@ProcessedAbility
public class PawnAbility
extends Ability
implements Listener {
    private Price price;
    private long cooldown;
    private long duration;
    private EntityBuilder entity;
    private int number;
    private transient Reforging plugin;

    @Override
    public void activate(Player player) {
        if (this.cooldownManager.isOnCooldown(player, this.cooldown, this.plugin)) {
            return;
        }
        this.cooldownManager.putOnCooldown(player, this.plugin);
        this.price.deduct(player);
        this.entity.nameFormattingContext(FormattingContext.builder().placeholder("player", player.getDisplayName()).build());
        ArrayList<Location> entities = new ArrayList<Location>();
        for (int i = 0; i < this.number; ++i) {
            entities.add(this.entity.persistentData("master", player).build(player.getLocation(), (DeltaPlugin)this.plugin));
        }
        if (this.duration > 0L) {
            this.plugin.getSynchronousScheduler().scheduleDelayedTask(() -> entities.forEach(Entity::remove), this.duration);
        }
    }

    @EventHandler
    public void onEntityTargetLivingEntity(EntityTargetLivingEntityEvent event) {
        LivingEntity target = event.getTarget();
        if (target != null) {
            event.setCancelled(PersistentDataWrapper.wrap((DeltaPlugin)this.plugin, (PersistentDataHolder)event.getEntity()).check("master", target));
        }
    }
}

