/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging.ability;

import com.aregcraft.reforging.Reforging;
import com.aregcraft.reforging.ability.Ability;
import com.aregcraft.reforging.ability.Price;
import com.aregcraft.reforging.api.DeltaPlugin;
import com.aregcraft.reforging.api.PersistentDataWrapper;
import com.aregcraft.reforging.api.entity.Entities;
import com.aregcraft.reforging.api.entity.ProjectileBuilder;
import com.aregcraft.reforging.meta.ProcessedAbility;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

@ProcessedAbility
public class FreezeAbility
extends Ability
implements Listener {
    private Price price;
    private long cooldown;
    private EntityType projectileType;
    private Vector projectileVelocity;
    private int duration;
    private transient Reforging plugin;

    @Override
    public void activate(Player player) {
        if (this.cooldownManager.isOnCooldown(player, this.cooldown, this.plugin)) {
            return;
        }
        this.cooldownManager.putOnCooldown(player, this.plugin);
        this.price.deduct(player);
        new ProjectileBuilder().source((ProjectileSource)player).type(this.projectileType).velocity(this.projectileVelocity).direction((Entity)player).persistentData("freeze", true).build(this.plugin);
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        Entity entity;
        if (PersistentDataWrapper.wrap((DeltaPlugin)this.plugin, (PersistentDataHolder)event.getEntity()).check("freeze", true) && (entity = event.getHitEntity()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            Entities.addPotionEffect(entity2, PotionEffectType.SLOW, this.duration, 255, true);
        }
    }
}

