/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging.ability;

import com.aregcraft.reforging.Reforging;
import com.aregcraft.reforging.ability.Ability;
import com.aregcraft.reforging.ability.Price;
import com.aregcraft.reforging.api.entity.Entities;
import com.aregcraft.reforging.api.entity.EntityFinder;
import com.aregcraft.reforging.api.entity.selector.ExcludingSelector;
import com.aregcraft.reforging.function.Function3;
import com.aregcraft.reforging.meta.ProcessedAbility;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

@ProcessedAbility
public class FireAbility
extends Ability {
    private Price price;
    private long cooldown;
    private Function3 function;
    private Particle particle;
    private int fireDuration;
    private transient Reforging plugin;

    @Override
    public void activate(Player player) {
        if (this.cooldownManager.isOnCooldown(player, this.cooldown, this.plugin)) {
            return;
        }
        this.cooldownManager.putOnCooldown(player, this.plugin);
        this.price.deduct(player);
        this.function.evaluate(it -> this.spawnParticleAndIgniteEntities(player, (Vector)it));
    }

    private void spawnParticleAndIgniteEntities(Player player, Vector vector) {
        Location location = player.getEyeLocation().add(this.getRelativeVector(player, vector));
        Entities.spawnParticle(this.particle, location);
        EntityFinder.createAtLocation(location, 0.5).find(LivingEntity.class, new ExcludingSelector((Entity)player)).forEach(it -> it.setFireTicks(this.fireDuration));
    }

    private Vector getRelativeVector(Player player, Vector vector) {
        Vector z = player.getLocation().getDirection();
        Vector x = z.getCrossProduct(new Vector(0, 1, 0)).normalize();
        return x.clone().multiply(vector.getX()).add(x.getCrossProduct(z).normalize().multiply(vector.getY())).add(z.multiply(vector.getZ()));
    }
}

