/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging.ability;

import com.aregcraft.reforging.Reforge;
import com.aregcraft.reforging.Reforging;
import com.aregcraft.reforging.api.RegisteredListener;
import com.aregcraft.reforging.api.block.custom.CustomBlock;
import com.aregcraft.reforging.api.entity.EquipmentWrapper;
import com.aregcraft.reforging.api.item.ItemWrapper;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;

@RegisteredListener
public class AbilityListener
implements Listener {
    private Reforging plugin;

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getHand() == EquipmentSlot.HAND && this.isRightClick(event.getAction()) && !CustomBlock.check(event.getClickedBlock(), "reforging_anvil", this.plugin)) {
            this.activateAbility(event.getPlayer());
        }
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (event.getHand() == EquipmentSlot.HAND) {
            this.activateAbility(event.getPlayer());
        }
    }

    private boolean isRightClick(Action action) {
        return action == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK;
    }

    private void activateAbility(Player player) {
        ItemWrapper item = EquipmentWrapper.wrap((LivingEntity)player).getItemInMainHand();
        if (item.getMaterial().isAir()) {
            return;
        }
        Reforge reforge = this.plugin.getReforge(item.getPersistentData(this.plugin).get("reforge", String.class));
        if (reforge != null) {
            reforge.activateAbility(player);
        }
    }
}

