/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging.ability;

import com.aregcraft.reforging.Reforging;
import com.aregcraft.reforging.ability.Ability;
import com.aregcraft.reforging.api.json.JsonReader;
import com.aregcraft.reforging.api.json.annotation.JsonAdapterFor;
import com.aregcraft.reforging.api.util.Classes;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import org.bukkit.event.Listener;

@JsonAdapterFor(value=Ability.class)
public class AbilityDeserializer
implements JsonDeserializer<Ability> {
    private static final String CLASS_NAME_TEMPLATE = "com.aregcraft.reforging.ability.%sAbility";
    private Reforging plugin;

    public Ability deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        if (json.isJsonPrimitive()) {
            return this.plugin.getAbility(json.getAsString());
        }
        JsonReader reader = new JsonReader(context, json);
        Ability ability = reader.deserialize(json, this.getClass(reader.getString("base")));
        Classes.setField(ability, "plugin", (Object)this.plugin);
        if (ability instanceof Listener) {
            Listener listener = (Listener)ability;
            this.plugin.registerListener(listener);
        }
        return ability;
    }

    private Class<? extends Ability> getClass(String base) {
        return Classes.getClass(CLASS_NAME_TEMPLATE.formatted(base));
    }
}

