/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging;

import com.aregcraft.reforging.LanguageLoader;
import com.aregcraft.reforging.Reforging;
import com.aregcraft.reforging.api.item.ItemWrapper;
import java.util.Arrays;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.inventory.EquipmentSlot;

public enum Weapon {
    STONE_SWORD(Material.COBBLESTONE, 4.0, 1.6),
    GOLDEN_SWORD(Material.GOLD_INGOT, 5.0, 1.6),
    IRON_SWORD(Material.IRON_INGOT, 6.0, 1.6),
    DIAMOND_SWORD(Material.DIAMOND, 7.0, 1.6),
    NETHERITE_SWORD(Material.NETHERITE_SCRAP, 8.0, 1.6),
    STONE_AXE(Material.COBBLESTONE, 7.0, 1.0),
    GOLDEN_AXE(Material.GOLDEN_AXE, 9.0, 0.8),
    IRON_AXE(Material.IRON_AXE, 9.0, 0.9),
    DIAMOND_AXE(Material.DIAMOND, 9.0, 1.0),
    NETHERITE_AXE(Material.NETHERITE_SCRAP, 10.0, 1.0);

    public static final double BASE_ATTACK_SPEED = 4.0;
    private final Material ingredient;
    private final double attackDamage;
    private final double attackSpeed;

    private Weapon(Material ingredient, double attackDamage, double attackSpeed) {
        this.ingredient = ingredient;
        this.attackDamage = attackDamage;
        this.attackSpeed = attackSpeed;
    }

    public static Weapon of(ItemWrapper item) {
        return Weapon.valueOf(item.getMaterial().name());
    }

    public static boolean isWeapon(ItemWrapper item) {
        return Arrays.stream(Weapon.values()).map(Enum::name).anyMatch(item.getMaterial().name()::equals);
    }

    public static boolean isWeapon(String name) {
        return Arrays.stream(Weapon.values()).map(Enum::name).map(LanguageLoader::getLanguageKey).anyMatch(name::equals);
    }

    public static boolean isIngredient(ItemWrapper item, ItemWrapper weapon) {
        return Weapon.valueOf((String)weapon.getMaterial().name()).ingredient.equals((Object)item.getMaterial());
    }

    public static boolean isReforgeStone(ItemWrapper item, Reforging plugin) {
        return item.getPersistentData(plugin).check("id", "reforge_stone");
    }

    public void addAttributeModifiers(ItemWrapper item) {
        item.createAttributeModifierBuilder().name("BASE_ATTACK_DAMAGE").attribute(Attribute.GENERIC_ATTACK_DAMAGE).amount(this.attackDamage).slot(EquipmentSlot.HAND).add();
        item.createAttributeModifierBuilder().name("BASE_ATTACK_SPEED").attribute(Attribute.GENERIC_ATTACK_SPEED).amount(this.attackSpeed - 4.0).slot(EquipmentSlot.HAND).add();
    }

    public double getAttackDamage() {
        return this.attackDamage;
    }

    public double getAttackSpeed() {
        return this.attackSpeed;
    }
}

