/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging;

import com.aregcraft.reforging.Reforging;
import com.aregcraft.reforging.api.json.annotation.JsonConfiguration;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.logging.Level;

@JsonConfiguration(value="update_checker")
public class UpdateChecker {
    private static final String META_URL = "https://raw.githubusercontent.com/Aregcraft/reforging/master/meta.json";
    private final String message;
    private final long period;

    public UpdateChecker(String message, long period) {
        this.message = message;
        this.period = period;
    }

    public void scheduleChecks(Reforging plugin) {
        plugin.getAsynchronousScheduler().scheduleRepeatingTask(() -> this.check(plugin), this.period);
    }

    public void check(Reforging plugin) {
        if (!plugin.getDescription().getVersion().equals(this.getLatestVersion(plugin))) {
            plugin.getLogger().log(Level.INFO, this.message);
        }
    }

    private String getLatestVersion(Reforging plugin) {
        String string;
        InputStreamReader reader = new InputStreamReader(new URL(META_URL).openStream());
        try {
            string = ((Meta)plugin.getGson().fromJson((Reader)reader, Meta.class)).version;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        reader.close();
        return string;
    }

    private static class Meta {
        private String version;

        private Meta() {
        }
    }
}

