/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging;

import com.aregcraft.reforging.Reforge;
import com.aregcraft.reforging.Reforging;
import com.aregcraft.reforging.Weapon;
import com.aregcraft.reforging.api.DeltaPlugin;
import com.aregcraft.reforging.api.block.BlockWrapper;
import com.aregcraft.reforging.api.block.custom.CustomBlock;
import com.aregcraft.reforging.api.block.custom.RegisteredCustomBlock;
import com.aregcraft.reforging.api.entity.EntityBuilder;
import com.aregcraft.reforging.api.entity.EquipmentWrapper;
import com.aregcraft.reforging.api.item.ItemWrapper;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.util.EulerAngle;

@RegisteredCustomBlock(value="reforging_anvil")
public class ReforgingAnvilBlock
implements CustomBlock {
    private Reforging plugin;
    private ArmorStand armorStand;

    @Override
    public ItemWrapper getItem() {
        return this.plugin.getReforgingAnvil().getItem();
    }

    @Override
    public void onEnable(Block block) {
        if (this.hasWeapon(block)) {
            this.setWeapon(block, this.getWeapon(block));
        }
    }

    @Override
    public void onDisable(Block block) {
        Optional.ofNullable(this.armorStand).ifPresent(Entity::remove);
    }

    @Override
    public void onBreak(BlockBreakEvent event) {
        this.dropWeapon(event.getBlock());
    }

    @Override
    public void onRightClick(PlayerInteractEvent event) {
        event.setCancelled(true);
        ItemWrapper item = ItemWrapper.wrap(event.getItem());
        Block block = event.getClickedBlock();
        if (item == null) {
            this.dropWeapon(block);
            return;
        }
        if (Weapon.isWeapon(item)) {
            this.dropWeapon(block);
            this.setWeapon(block, item);
            item.decrementAmount();
            return;
        }
        if (!this.hasWeapon(block)) {
            return;
        }
        Player player = event.getPlayer();
        if (Weapon.isReforgeStone(item, this.plugin)) {
            this.applyReforge(block, player, this.plugin.getUltimateReforge(item));
            item.decrementAmount();
            return;
        }
        if (!Weapon.isIngredient(item, this.getWeapon(block))) {
            return;
        }
        if (this.plugin.getReforgingAnvil().deductPrice(item)) {
            this.applyReforge(block, player, this.plugin.getRandomStandardReforge());
        }
    }

    private void applyReforge(Block block, Player player, Reforge reforge) {
        this.setWeapon(block, reforge.apply(player, this.getWeapon(block), this.plugin));
        this.dropWeapon(block);
        this.plugin.getReforgingAnvil().playSound(block);
    }

    private void dropWeapon(Block block) {
        if (this.hasWeapon(block)) {
            this.getWeapon(block).dropNaturally(block.getLocation().add(0.0, 1.0, 0.0));
            this.setWeapon(block, null);
        }
        Optional.ofNullable(this.armorStand).ifPresent(Entity::remove);
        this.armorStand = null;
    }

    private boolean hasWeapon(Block block) {
        return BlockWrapper.wrap(block, (DeltaPlugin)this.plugin).getPersistentData().has("weapon", ItemWrapper.class);
    }

    private ItemWrapper getWeapon(Block block) {
        return BlockWrapper.wrap(block, (DeltaPlugin)this.plugin).getPersistentData().get("weapon", ItemWrapper.class);
    }

    private void setWeapon(Block block, ItemWrapper weapon) {
        BlockWrapper.wrap(block, (DeltaPlugin)this.plugin).getPersistentData().set("weapon", weapon);
        if (this.armorStand == null) {
            this.createArmorStand(block);
        }
        EquipmentWrapper.wrap((LivingEntity)this.armorStand).setItemInMainHand(weapon);
    }

    private void createArmorStand(Block block) {
        Location location = block.getLocation().subtract(0.0, 0.25, 0.0);
        switch (((Directional)block.getBlockData()).getFacing()) {
            case NORTH: 
            case SOUTH: {
                location.add(0.25, 0.0, 0.0);
                break;
            }
            case EAST: 
            case WEST: {
                location.add(0.0, 0.0, 0.75);
                location.setYaw(270.0f);
            }
        }
        this.armorStand = (ArmorStand)EntityBuilder.createArmorStand().build(location, (DeltaPlugin)this.plugin);
        this.armorStand.setRightArmPose(new EulerAngle(0.0, 0.0, 4.71238898038469));
    }
}

