/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging;

import com.aregcraft.reforging.Identifiable;
import com.aregcraft.reforging.LanguageLoader;
import com.aregcraft.reforging.Reforge;
import com.aregcraft.reforging.ReforgeStone;
import com.aregcraft.reforging.ReforgingAnvil;
import com.aregcraft.reforging.UpdateChecker;
import com.aregcraft.reforging.ability.Ability;
import com.aregcraft.reforging.api.DeltaPlugin;
import com.aregcraft.reforging.api.item.ItemDisplay;
import com.aregcraft.reforging.api.item.ItemWrapper;
import com.aregcraft.reforging.api.json.JsonConfigurationLoader;
import com.aregcraft.reforging.bukkit.Metrics;
import com.google.gson.reflect.TypeToken;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;

public class Reforging
extends DeltaPlugin {
    private static final TypeToken<List<Reforge>> REFORGES_TYPE = new TypeToken<List<Reforge>>(){};
    private static final TypeToken<List<ReforgeStone>> REFORGE_STONES_TYPE = new TypeToken<List<ReforgeStone>>(){};
    private static final TypeToken<Map<String, Double>> REFORGE_WEIGHTS_TYPE = new TypeToken<Map<String, Double>>(){};
    private static final TypeToken<List<Ability>> ABILITIES_TYPE = new TypeToken<List<Ability>>(){};
    private final JsonConfigurationLoader configurationLoader = JsonConfigurationLoader.builder().name(REFORGES_TYPE, "reforges").name(REFORGE_STONES_TYPE, "reforge_stones").name(REFORGE_WEIGHTS_TYPE, "reforge_weights").name(ABILITIES_TYPE, "abilities").plugin(this).build();
    private final LanguageLoader languageLoader = new LanguageLoader(this);
    private final Random random = new Random();

    @Override
    public void onEnable() {
        super.onEnable();
        this.load();
        this.configurationLoader.get(UpdateChecker.class).scheduleChecks(this);
        new Metrics(this, 16827);
    }

    public ReforgingAnvil getReforgingAnvil() {
        return this.configurationLoader.get(ReforgingAnvil.class);
    }

    public ItemDisplay getItemDisplay() {
        return this.configurationLoader.get("item", ItemDisplay.class);
    }

    public Reforge getRandomStandardReforge() {
        return this.getReforge((String)this.configurationLoader.get(REFORGE_WEIGHTS_TYPE).entrySet().stream().map(it -> Map.entry((String)it.getKey(), -Math.log(this.random.nextDouble()) / (Double)it.getValue())).min(Map.Entry.comparingByValue()).orElseThrow().getKey());
    }

    public Reforge getUltimateReforge(ItemWrapper stone) {
        return this.getReforge(stone.getPersistentData(this).get("reforge_id", String.class));
    }

    public Reforge getReforge(String id) {
        return (Reforge)Identifiable.find((Collection)this.configurationLoader.get(REFORGES_TYPE), id);
    }

    public Ability getAbility(String id) {
        return (Ability)Identifiable.find((Collection)this.configurationLoader.get(ABILITIES_TYPE), id);
    }

    public List<String> getReforgeIds() {
        return this.configurationLoader.get(REFORGES_TYPE).stream().map(Identifiable::getId).toList();
    }

    public String getDefaultName(Player player, ItemWrapper item) {
        return this.languageLoader.get(player, item);
    }

    public void reload() {
        this.configurationLoader.get(ABILITIES_TYPE).stream().filter(Listener.class::isInstance).map(Listener.class::cast).forEach(this::unregisterListener);
        this.configurationLoader.invalidateAll();
        this.load();
    }

    private void load() {
        this.getReforgingAnvil().register(this);
        this.configurationLoader.get(REFORGE_STONES_TYPE).forEach(it -> it.register(this));
        this.configurationLoader.get(ABILITIES_TYPE);
    }
}

