/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging;

import com.aregcraft.reforging.Identifiable;
import com.aregcraft.reforging.Reforging;
import com.aregcraft.reforging.Weapon;
import com.aregcraft.reforging.ability.Ability;
import com.aregcraft.reforging.api.FormattingContext;
import com.aregcraft.reforging.api.PersistentDataWrapper;
import com.aregcraft.reforging.api.item.ItemDisplay;
import com.aregcraft.reforging.api.item.ItemWrapper;
import java.text.DecimalFormat;
import java.util.Map;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;

public class Reforge
implements Identifiable,
Listener {
    private final String id;
    private final String name;
    private final Map<Attribute, Double> attributes;
    private final Ability ability;

    public Reforge(String id, String name, Map<Attribute, Double> attributes, Ability ability) {
        this.id = id;
        this.name = name;
        this.attributes = attributes;
        this.ability = ability;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void activateAbility(Player player) {
        if (this.ability != null) {
            this.ability.activate(player);
        }
    }

    public ItemWrapper apply(Player player, ItemWrapper item, Reforging plugin) {
        PersistentDataWrapper persistentData = item.getPersistentData(plugin);
        persistentData.remove("cooldown");
        persistentData.setIfAbsent("name", item.getNameOrElse(plugin.getDefaultName(player, item)));
        ItemDisplay display = plugin.getItemDisplay();
        if (persistentData.has("reforge", String.class)) {
            item.removeLore(display.lore());
            item.removeAttributeModifiers(persistentData.get("reforge", String.class));
        } else {
            item.addFlags(ItemFlag.HIDE_ATTRIBUTES);
            Weapon.of(item).addAttributeModifiers(item);
        }
        persistentData.set("reforge", this.id);
        item.setFormattingContext(this.getFormattingContext(item, plugin));
        item.setDisplay(display);
        this.attributes.forEach((attribute, amount) -> this.addAttributeModifier(item, (Attribute)attribute, (double)amount));
        return item;
    }

    private void addAttributeModifier(ItemWrapper item, Attribute attribute, double amount) {
        item.createAttributeModifierBuilder().attribute(attribute).name(this.id).amount(amount).slot(EquipmentSlot.HAND).add();
    }

    private FormattingContext getFormattingContext(ItemWrapper item, Reforging plugin) {
        Weapon weapon = Weapon.of(item);
        FormattingContext.Builder builder = FormattingContext.builder().placeholder("name", item.getPersistentData(plugin).get("name", String.class)).placeholder("reforge_name", this.name).placeholder("base_attack_damage", weapon.getAttackDamage()).placeholder("base_attack_speed", weapon.getAttackSpeed()).formatter(Double.class, new DecimalFormat()::format);
        this.attributes.forEach((attribute, amount) -> builder.placeholder(attribute.name().toLowerCase(), amount));
        if (!this.attributes.containsKey(Attribute.GENERIC_ATTACK_DAMAGE)) {
            builder.placeholder("generic_attack_damage", 0);
        }
        if (!this.attributes.containsKey(Attribute.GENERIC_ATTACK_SPEED)) {
            builder.placeholder("generic_attack_speed", 0);
        }
        return builder.build();
    }
}

