/*
 * Decompiled with CFR 0.152.
 */
package com.aregcraft.reforging;

import com.aregcraft.reforging.Reforging;
import com.aregcraft.reforging.Weapon;
import com.aregcraft.reforging.api.item.ItemWrapper;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

public class LanguageLoader
implements Listener {
    private static final String LANG_URL = "https://assets.mcasset.cloud/1.19.2/assets/minecraft/lang/%s.json";
    private static final TypeToken<Map<String, String>> LANG_TYPE = new TypeToken<Map<String, String>>(){};
    private final Reforging plugin;
    private final LoadingCache<String, Map<String, String>> cache;

    public LanguageLoader(Reforging plugin) {
        this.plugin = plugin;
        this.cache = CacheBuilder.newBuilder().build((CacheLoader)new LanguageCacheLoader());
        plugin.registerListener(this);
    }

    public static String getLanguageKey(String name) {
        return "item.minecraft." + name.toLowerCase();
    }

    public String get(Player player, ItemWrapper item) {
        return (String)((Map)this.cache.getUnchecked((Object)player.getLocale())).get(LanguageLoader.getLanguageKey(item.getMaterial().name()));
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        String locale = event.getPlayer().getLocale();
        if (!this.cache.asMap().containsKey(locale)) {
            CompletableFuture.runAsync(() -> this.cache.refresh((Object)locale));
        }
    }

    private class LanguageCacheLoader
    extends CacheLoader<String, Map<String, String>> {
        private LanguageCacheLoader() {
        }

        public Map<String, String> load(String key) {
            Map<String, String> map;
            InputStreamReader reader = new InputStreamReader(new URL(LanguageLoader.LANG_URL.formatted(key)).openStream());
            try {
                map = this.getWeapons((Map)LanguageLoader.this.plugin.getGson().fromJson((Reader)reader, LANG_TYPE.getType()));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            reader.close();
            return map;
        }

        private Map<String, String> getWeapons(Map<String, String> items) {
            return items.entrySet().stream().filter(it -> Weapon.isWeapon((String)it.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }
}

