/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.world.populator.builtin;

import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.block.magic.MagicBlock;
import com.elmakers.mine.bukkit.utility.random.RandomUtils;
import com.elmakers.mine.bukkit.utility.random.WeightedPair;
import com.elmakers.mine.bukkit.world.BlockResult;
import com.elmakers.mine.bukkit.world.populator.BaseBlockPopulator;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;

public class MagicBlockPopulator
extends BaseBlockPopulator {
    protected MaterialSet replace;
    protected Deque<WeightedPair<String>> templateProbability = new ArrayDeque<WeightedPair<String>>();
    protected ConfigurationSection parameters;

    @Override
    public boolean onLoad(ConfigurationSection parameters) {
        RandomUtils.populateStringProbabilityMap(this.templateProbability, parameters, "template");
        this.parameters = parameters.getConfigurationSection("block_parameters");
        this.replace = this.controller.getMaterialSetManager().fromConfig(parameters.getString("replace"));
        String message = "Creating magic block " + StringUtils.join(RandomUtils.getValues(this.templateProbability), (String)",");
        if (this.replace != null) {
            message = message + " on generation of " + StringUtils.join(this.replace.getMaterials(), (String)",");
        }
        this.logBlockRule(message);
        return !this.templateProbability.isEmpty();
    }

    @Override
    public BlockResult populate(Block block, Random random) {
        if (this.replace != null && !this.replace.testBlock(block)) {
            return BlockResult.SKIP;
        }
        String templateKey = (String)RandomUtils.weightedRandom(this.templateProbability);
        if (templateKey.equalsIgnoreCase("none")) {
            return BlockResult.SKIP;
        }
        try {
            BlockResult result = BlockResult.valueOf(templateKey.toUpperCase());
            return result;
        }
        catch (Exception result) {
            Location location = block.getLocation();
            MagicBlock automaton = this.controller.addMagicBlock(location, templateKey, null, null, this.parameters);
            String message = " magic block: " + templateKey + " at " + location.getWorld().getName() + "," + location.toVector();
            message = automaton == null ? "Failed to create" + message : "Created" + message;
            this.controller.info(message);
            return automaton == null ? BlockResult.SKIP : BlockResult.REMOVE_DROPS;
        }
    }
}

