/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.world;

import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.world.BlockResult;
import com.elmakers.mine.bukkit.world.block.MagicBlockHandler;
import com.elmakers.mine.bukkit.world.populator.MagicChunkHandler;
import com.elmakers.mine.bukkit.world.populator.MagicChunkPopulator;
import com.elmakers.mine.bukkit.world.spawn.MagicSpawnHandler;
import com.elmakers.mine.bukkit.world.tasks.CheckWorldCreateTask;
import com.elmakers.mine.bukkit.world.tasks.CopyWorldTask;
import java.util.Collection;
import java.util.Objects;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class MagicWorld {
    private static boolean updatingTime = false;
    private final MagicController controller;
    private final MagicChunkHandler chunkHandler;
    private final MagicSpawnHandler spawnHandler;
    private final MagicBlockHandler blockPlaceHandler;
    private final MagicBlockHandler blockBreakHandler;
    private String copyFrom = "";
    private boolean autoLoad = false;
    private boolean cancelSpellsOnSave = true;
    private World.Environment worldEnvironment = World.Environment.NORMAL;
    private World.Environment appearanceEnvironment = null;
    private WorldType worldType = WorldType.NORMAL;
    private String worldName;
    private String resourcePack;
    private long seed;
    private boolean synchronizeTime = true;
    private boolean installed = false;
    private long synchronizedTimeOffset = 0L;
    private static Random random = new Random();
    private WorldState state = WorldState.UNLOADED;
    private Integer maxHeight;
    private Integer minHeight;
    private GameMode gameMode;
    private GameMode leavingGameMode;

    public MagicWorld(MagicController controller) {
        this.controller = controller;
        this.seed = random.nextLong();
        this.chunkHandler = new MagicChunkHandler(controller);
        this.spawnHandler = new MagicSpawnHandler(controller);
        this.blockPlaceHandler = new MagicBlockHandler(controller);
        this.blockBreakHandler = new MagicBlockHandler(controller);
    }

    public void load(String name, ConfigurationSection config) {
        String modeString;
        String typeString;
        this.worldName = name;
        if (config.contains("max_height")) {
            this.maxHeight = config.getInt("max_height");
        }
        if (config.contains("min_height")) {
            this.minHeight = config.getInt("min_height");
        }
        this.copyFrom = config.getString("copy", this.copyFrom);
        this.synchronizeTime = config.getBoolean("synchronize_time", this.synchronizeTime);
        this.synchronizedTimeOffset = config.getLong("time_offset", this.synchronizedTimeOffset);
        this.resourcePack = config.getString("resource_pack", this.resourcePack);
        if (config.contains("environment")) {
            typeString = config.getString("environment");
            try {
                this.worldEnvironment = World.Environment.valueOf((String)typeString.toUpperCase());
            }
            catch (Exception ex) {
                this.controller.getLogger().warning("Invalid world environment: " + typeString);
            }
        }
        if (config.contains("appearance")) {
            typeString = config.getString("appearance");
            try {
                this.appearanceEnvironment = World.Environment.valueOf((String)typeString.toUpperCase());
            }
            catch (Exception ex) {
                this.controller.getLogger().warning("Invalid world appearance: " + typeString);
            }
        }
        if (config.contains("type")) {
            typeString = config.getString("type");
            try {
                this.worldType = WorldType.valueOf((String)typeString.toUpperCase());
            }
            catch (Exception ex) {
                this.controller.getLogger().warning("Invalid world type: " + typeString);
            }
        }
        if (config.contains("game_mode")) {
            modeString = config.getString("game_mode");
            try {
                this.gameMode = GameMode.valueOf((String)modeString.toUpperCase());
            }
            catch (Exception ex) {
                this.controller.getLogger().warning("Invalid game mode: " + modeString);
            }
        }
        if (config.contains("leave_game_mode")) {
            modeString = config.getString("leave_game_mode");
            try {
                this.leavingGameMode = GameMode.valueOf((String)modeString.toUpperCase());
            }
            catch (Exception ex) {
                this.controller.getLogger().warning("Invalid game mode: " + modeString);
            }
        }
        this.seed = config.getLong("seed", this.seed);
        this.autoLoad = config.getBoolean("autoload", this.autoLoad);
        this.chunkHandler.load(this.worldName, config.getConfigurationSection("chunk_generate"));
        this.blockBreakHandler.load(this.worldName, "break", config.getConfigurationSection("block_break"));
        this.blockPlaceHandler.load(this.worldName, "place", config.getConfigurationSection("block_place"));
        this.spawnHandler.load(this.worldName, config.getConfigurationSection("entity_spawn"));
        this.cancelSpellsOnSave = config.getBoolean("cancel_spells_on_save", this.cancelSpellsOnSave);
    }

    public void finalizeLoad() {
        if (this.autoLoad) {
            Bukkit.getScheduler().runTaskLater(this.controller.getPlugin(), (Runnable)new CheckWorldCreateTask(this), 1L);
        }
        if (!this.installed) {
            this.installPopulators(Bukkit.getWorld((String)this.worldName));
        }
        this.spawnHandler.finalizeLoad();
    }

    public World checkWorldCreate() {
        if (this.state != WorldState.UNLOADED) {
            return Bukkit.getWorld((String)this.worldName);
        }
        if (this.copyFrom.isEmpty()) {
            return this.createWorld();
        }
        World targetWorld = this.controller.getPlugin().getServer().getWorld(this.copyFrom);
        if (targetWorld != null) {
            return this.copyWorld(targetWorld);
        }
        return null;
    }

    public World createWorld() {
        this.state = WorldState.LOADING;
        World world = Bukkit.getWorld((String)this.worldName);
        if (world == null) {
            this.controller.info("Loading " + this.worldName + " as " + this.worldEnvironment + " (" + this.worldType + ")");
            WorldCreator worldCreator = WorldCreator.name((String)this.worldName);
            worldCreator.seed(this.seed);
            worldCreator.environment(this.worldEnvironment);
            worldCreator.type(this.worldType);
            worldCreator.generateStructures(true);
            try {
                world = worldCreator.createWorld();
            }
            catch (Exception ex) {
                world = null;
                ex.printStackTrace();
            }
            if (world == null) {
                this.controller.getLogger().warning("Failed to create world: " + this.worldName);
            }
        }
        if (world != null && this.appearanceEnvironment != null) {
            CompatibilityLib.getCompatibilityUtils().setEnvironment(world, this.appearanceEnvironment);
            this.controller.info("Changed " + this.worldName + " appearance to " + this.appearanceEnvironment);
        }
        return world;
    }

    public void installPopulators(World world) {
        if (world == null || this.installed || this.chunkHandler.isEmpty()) {
            return;
        }
        Collection<MagicChunkPopulator> populators = this.chunkHandler.getPopulators();
        if (populators == null || populators.isEmpty()) {
            return;
        }
        this.controller.info("Installing Populators in " + world.getName());
        world.getPopulators().addAll(populators);
        this.installed = true;
    }

    public void remove() {
        if (!this.installed) {
            return;
        }
        World world = Bukkit.getWorld((String)this.worldName);
        if (world != null) {
            world.getPopulators().removeAll(this.chunkHandler.getPopulators());
        }
        this.installed = false;
    }

    public boolean processEntitySpawn(Plugin plugin, LivingEntity entity) {
        return this.spawnHandler.process(plugin, entity);
    }

    public BlockResult processBlockBreak(Block block, Player player) {
        return this.blockBreakHandler.handleBlock(block, player);
    }

    public BlockResult processBlockPlace(Block block, Player player) {
        return this.blockPlaceHandler.handleBlock(block, player);
    }

    public void onWorldInit(World initWorld) {
        if (initWorld.getName().equals(this.worldName)) {
            this.state = WorldState.LOADED;
            this.updateTime();
            return;
        }
        if (this.state != WorldState.UNLOADED) {
            return;
        }
        if (this.autoLoad && !this.copyFrom.isEmpty() && initWorld.getName().equals(this.copyFrom)) {
            Bukkit.getScheduler().runTaskLater(this.controller.getPlugin(), (Runnable)new CopyWorldTask(this, initWorld), 1L);
        }
    }

    public World copyWorld(World targetWorld) {
        World world;
        if (!this.copyFrom.isEmpty() && !targetWorld.getName().equals(this.copyFrom)) {
            this.controller.getLogger().warning("World " + this.worldName + " getting created as a copy of " + targetWorld.getName() + ", but is configured to copy " + this.copyFrom);
        }
        if ((world = Bukkit.getWorld((String)this.worldName)) == null) {
            this.state = WorldState.LOADING;
            this.controller.info("Loading " + this.worldName + " using settings copied from " + targetWorld.getName());
            world = Bukkit.createWorld((WorldCreator)new WorldCreator(this.worldName).copy(targetWorld));
            if (world == null) {
                this.controller.getLogger().warning("Failed to create world: " + this.worldName);
            } else if (this.appearanceEnvironment != null) {
                CompatibilityLib.getCompatibilityUtils().setEnvironment(world, this.appearanceEnvironment);
                this.controller.info("Changed " + this.worldName + " appearance to " + this.appearanceEnvironment);
            }
        }
        return world;
    }

    public void playerJoined(Mage mage) {
        this.playerEntered(mage, null, true);
    }

    public void playerEntered(Mage mage, MagicWorld previousWorld) {
        this.playerEntered(mage, previousWorld, false);
    }

    public void playerEntered(Mage mage, MagicWorld previousWorld, boolean isJoin) {
        MagicWorld.joinedDefault(mage, this.resourcePack, previousWorld, isJoin);
        if (this.gameMode != null && (previousWorld == null || previousWorld.gameMode != this.gameMode)) {
            mage.getPlayer().setGameMode(this.gameMode);
        }
    }

    public void playerLeft(Mage mage, MagicWorld nextWorld) {
        if (this.leavingGameMode != null && (nextWorld == null || nextWorld.gameMode == null)) {
            mage.getPlayer().setGameMode(this.leavingGameMode);
        }
    }

    public static void joinedDefault(Mage mage) {
        MagicWorld.joinedDefault(mage, null, null, true);
    }

    private static void joinedDefault(Mage mage, String resourcePack, MagicWorld previousWorld, boolean isJoin) {
        MagicController controller = mage.getController();
        if (!controller.isResourcePackEnabled()) {
            return;
        }
        if (mage.isResourcePackEnabled()) {
            String fromResourcePack;
            String string = fromResourcePack = previousWorld == null ? null : previousWorld.resourcePack;
            if (!Objects.equals(fromResourcePack, resourcePack) || isJoin) {
                controller.promptResourcePack(mage.getPlayer(), resourcePack);
            }
        } else if (isJoin && mage.isResourcePackPrompt()) {
            controller.promptNoResourcePack(mage.getPlayer());
        }
    }

    public void updateTime() {
        this.updateTimeFrom(null, 0L);
    }

    public void updateTimeFrom(World changedWorld, long skipAmount) {
        if (!this.synchronizeTime || this.copyFrom.isEmpty() || this.state != WorldState.LOADED || updatingTime) {
            return;
        }
        World world = Bukkit.getWorld((String)this.worldName);
        if (changedWorld != null && this.worldName.equals(changedWorld.getName())) {
            if (world != null) {
                updatingTime = true;
                changedWorld.setTime(world.getTime() - this.synchronizedTimeOffset + skipAmount);
                updatingTime = false;
            }
            return;
        }
        if (changedWorld == null) {
            changedWorld = Bukkit.getWorld((String)this.copyFrom);
        } else if (!changedWorld.getName().equals(this.copyFrom)) {
            return;
        }
        if (changedWorld == null) {
            return;
        }
        if (world != null) {
            updatingTime = true;
            world.setTime(changedWorld.getTime() + this.synchronizedTimeOffset + skipAmount);
            updatingTime = false;
        }
    }

    public boolean isCancelSpellsOnSave() {
        return this.cancelSpellsOnSave;
    }

    public int getMaxHeight(int defaultHeight) {
        return this.maxHeight != null ? this.maxHeight : defaultHeight;
    }

    public int getMinHeight(int defaultHeight) {
        return this.minHeight != null ? this.minHeight : defaultHeight;
    }

    private static enum WorldState {
        UNLOADED,
        LOADING,
        LOADED;

    }
}

