/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.random;

import com.elmakers.mine.bukkit.utility.random.ValueParser;

public class WeightedPair<T>
implements Comparable<WeightedPair<? extends Object>> {
    private final Float threshold;
    private final Float rawThreshold;
    private final T value;

    public WeightedPair(Float threshold, Float rawThreshold, String value, ValueParser<T> parser) {
        this.threshold = threshold;
        this.rawThreshold = rawThreshold;
        this.value = parser == null ? null : parser.parse(value);
    }

    public WeightedPair(T value) {
        this(Float.valueOf(1.0f), Float.valueOf(1.0f), value);
    }

    public WeightedPair(Float threshold, T value) {
        this(threshold, threshold, value);
    }

    public WeightedPair(Float threshold, Float rawThreshold, T value) {
        this.threshold = threshold;
        this.value = value;
        this.rawThreshold = rawThreshold;
    }

    public WeightedPair(WeightedPair<?> weights, T value) {
        this.threshold = weights.threshold;
        this.value = value;
        this.rawThreshold = weights.rawThreshold;
    }

    public Float getThreshold() {
        return this.threshold;
    }

    public Float getRawThreshold() {
        return this.rawThreshold;
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public int compareTo(WeightedPair<? extends Object> other) {
        return this.threshold.compareTo(other.threshold);
    }

    public String toString() {
        return this.value.toString();
    }
}

