/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.v1_16.entity;

import com.elmakers.mine.bukkit.api.magic.MageController;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fox;

public class EntityFoxData
extends com.elmakers.mine.bukkit.utility.platform.v1_14.entity.EntityFoxData {
    private UUID firstTrusted;
    private UUID secondTrusted;

    public EntityFoxData(ConfigurationSection parameters, MageController controller) {
        super(parameters, controller);
        String secondTrusted;
        Logger log = controller.getLogger();
        String trusted = parameters.getString("trusted");
        if (trusted != null && !trusted.isEmpty()) {
            try {
                this.firstTrusted = UUID.fromString(trusted);
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Invalid trusted UUID: " + trusted, ex);
            }
        }
        if ((secondTrusted = parameters.getString("second_trusted")) != null && !secondTrusted.isEmpty()) {
            try {
                this.secondTrusted = UUID.fromString(secondTrusted);
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Invalid trusted UUID: " + secondTrusted, ex);
            }
        }
    }

    public EntityFoxData(Entity entity) {
        super(entity);
        if (entity instanceof Fox) {
            AnimalTamer second;
            Fox fox = (Fox)entity;
            AnimalTamer trusted = fox.getFirstTrustedPlayer();
            if (trusted != null) {
                this.firstTrusted = trusted.getUniqueId();
            }
            if ((second = fox.getSecondTrustedPlayer()) != null) {
                this.secondTrusted = second.getUniqueId();
            }
        }
    }

    @Override
    public void apply(Entity entity) {
        super.apply(entity);
        if (entity instanceof Fox) {
            OfflinePlayer trusted;
            Fox fox = (Fox)entity;
            if (this.firstTrusted != null && (trusted = Bukkit.getOfflinePlayer((UUID)this.firstTrusted)) != null) {
                fox.setFirstTrustedPlayer((AnimalTamer)trusted);
            }
            if (this.secondTrusted != null && (trusted = Bukkit.getOfflinePlayer((UUID)this.secondTrusted)) != null) {
                fox.setSecondTrustedPlayer((AnimalTamer)trusted);
            }
        }
    }
}

