/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.v1_14.entity;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.utility.ConfigUtils;
import com.elmakers.mine.bukkit.utility.platform.base.entity.EntityAnimalData;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fox;

public class EntityFoxData
extends EntityAnimalData {
    private Fox.Type type;
    private Boolean crouching;

    public EntityFoxData(ConfigurationSection parameters, MageController controller) {
        super(parameters, controller);
        Logger log = controller.getLogger();
        String typeString = parameters.getString("fox_type");
        if (typeString != null && !typeString.isEmpty()) {
            try {
                this.type = Fox.Type.valueOf((String)typeString.toUpperCase());
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Invalid fox_type: " + typeString, ex);
            }
        }
        this.crouching = ConfigUtils.getOptionalBoolean(parameters, "crouching");
    }

    public EntityFoxData(Entity entity) {
        super(entity);
        if (entity instanceof Fox) {
            Fox fox = (Fox)entity;
            this.type = fox.getFoxType();
            this.crouching = fox.isCrouching();
        }
    }

    @Override
    public void apply(Entity entity) {
        super.apply(entity);
        if (entity instanceof Fox) {
            Fox fox = (Fox)entity;
            if (this.type != null) {
                fox.setFoxType(this.type);
            }
            if (this.crouching != null) {
                fox.setCrouching(this.crouching.booleanValue());
            }
        }
    }

    @Override
    public boolean cycle(Entity entity) {
        if (!this.canCycle(entity)) {
            return false;
        }
        Fox fox = (Fox)entity;
        Fox.Type type = fox.getFoxType();
        Fox.Type[] typeValues = Fox.Type.values();
        int typeOrdinal = (type.ordinal() + 1) % typeValues.length;
        type = typeValues[typeOrdinal];
        fox.setFoxType(type);
        return true;
    }

    @Override
    public boolean canCycle(Entity entity) {
        return entity instanceof Fox;
    }
}

