/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.legacy;

import com.elmakers.mine.bukkit.utility.platform.Platform;
import com.elmakers.mine.bukkit.utility.platform.base.ItemUtilsBase;
import com.elmakers.mine.bukkit.utility.platform.legacy.NMSUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ItemUtils
extends ItemUtilsBase {
    public ItemUtils(Platform platform) {
        super(platform);
    }

    @Override
    public Object getHandle(ItemStack stack) {
        Object handle = null;
        try {
            handle = NMSUtils.class_CraftItemStack_getHandleField.get(stack);
        }
        catch (Throwable ex) {
            handle = null;
        }
        return handle;
    }

    @Override
    public Object getTag(Object mcItemStack) {
        Object tag = null;
        try {
            tag = NMSUtils.class_ItemStack_tagField.get(mcItemStack);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return tag;
    }

    @Override
    public Object getTag(ItemStack itemStack) {
        Object tag = null;
        try {
            Object mcItemStack = this.getHandle(itemStack);
            if (mcItemStack == null && itemStack.hasItemMeta()) {
                itemStack = this.makeReal(itemStack);
                mcItemStack = this.getHandle(itemStack);
            }
            if (mcItemStack == null) {
                return null;
            }
            tag = NMSUtils.class_ItemStack_tagField.get(mcItemStack);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return tag;
    }

    protected Object getNMSCopy(ItemStack stack) {
        Object nms = null;
        try {
            nms = NMSUtils.class_CraftItemStack_copyMethod.invoke(null, stack);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return nms;
    }

    @Override
    public ItemStack getCopy(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (NMSUtils.class_CraftItemStack_mirrorMethod == null) {
            return stack;
        }
        try {
            Object craft = this.getNMSCopy(stack);
            stack = (ItemStack)NMSUtils.class_CraftItemStack_mirrorMethod.invoke(null, craft);
        }
        catch (Throwable ex) {
            stack = null;
        }
        return stack;
    }

    @Override
    public ItemStack makeReal(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        Object nmsStack = this.getHandle(stack);
        if (nmsStack == null) {
            stack = this.getCopy(stack);
            nmsStack = this.getHandle(stack);
        }
        if (nmsStack == null) {
            return null;
        }
        try {
            Object tag = NMSUtils.class_ItemStack_tagField.get(nmsStack);
            if (tag == null) {
                NMSUtils.class_ItemStack_tagField.set(nmsStack, NMSUtils.class_NBTTagCompound_constructor.newInstance(new Object[0]));
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
        return stack;
    }

    @Override
    public boolean isUnbreakable(ItemStack stack) {
        if (this.isEmpty(stack)) {
            return false;
        }
        Boolean unbreakableFlag = null;
        try {
            Object tagObject = this.getTag(stack);
            if (tagObject == null) {
                return false;
            }
            unbreakableFlag = this.platform.getNBTUtils().getOptionalBoolean(tagObject, "Unbreakable");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return unbreakableFlag != null && unbreakableFlag != false;
    }

    @Override
    public void makeUnbreakable(ItemStack stack) {
        if (this.isEmpty(stack)) {
            return;
        }
        try {
            Object craft = this.getHandle(stack);
            if (craft == null) {
                return;
            }
            Object tagObject = this.getTag(craft);
            if (tagObject == null) {
                return;
            }
            Object unbreakableFlag = null;
            unbreakableFlag = NMSUtils.class_NBTTagByte_constructor.newInstance((byte)1);
            NMSUtils.class_NBTTagCompound_setMethod.invoke(tagObject, "Unbreakable", unbreakableFlag);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void removeUnbreakable(ItemStack stack) {
        this.platform.getNBTUtils().removeMeta(stack, "Unbreakable");
    }

    @Override
    public void hideFlags(ItemStack stack, int flags) {
        if (this.isEmpty(stack)) {
            return;
        }
        try {
            Object craft = this.getHandle(stack);
            if (craft == null) {
                return;
            }
            Object tagObject = this.getTag(craft);
            if (tagObject == null) {
                return;
            }
            Object hideFlag = null;
            hideFlag = NMSUtils.class_NBTTagInt_constructor.newInstance(flags);
            NMSUtils.class_NBTTagCompound_setMethod.invoke(tagObject, "HideFlags", hideFlag);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean isEmpty(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return true;
        }
        if (NMSUtils.class_ItemStack_isEmptyMethod == null) {
            return false;
        }
        try {
            Object handle = this.getHandle(itemStack);
            if (handle == null) {
                return false;
            }
            return (Boolean)NMSUtils.class_ItemStack_isEmptyMethod.invoke(handle, new Object[0]);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
    }

    protected Object getTagString(String value) {
        try {
            return NMSUtils.class_NBTTagString_consructor.newInstance(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public Object setStringList(Object nbtBase, String tag, Collection<String> values) {
        if (nbtBase == null) {
            return null;
        }
        Object listMeta = null;
        try {
            listMeta = NMSUtils.class_NBTTagList_constructor.newInstance(new Object[0]);
            for (String value : values) {
                Object nbtString = this.getTagString(value);
                this.platform.getNBTUtils().addToList(listMeta, nbtString);
            }
            NMSUtils.class_NBTTagCompound_setMethod.invoke(nbtBase, tag, listMeta);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
        return listMeta;
    }

    @Override
    public List<String> getStringList(Object nbtBase, String key) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Object listTag = NMSUtils.class_NBTTagCompound_getListMethod.invoke(nbtBase, key, 8);
            if (listTag != null) {
                int size = (Integer)NMSUtils.class_NBTTagList_sizeMethod.invoke(listTag, new Object[0]);
                for (int i = 0; i < size; ++i) {
                    Object item = NMSUtils.class_NBTTagList_getStringMethod.invoke(listTag, i);
                    if (item == null || !(item instanceof String)) continue;
                    list.add((String)item);
                }
            }
        }
        catch (Exception ex) {
            this.platform.getLogger().log(Level.WARNING, "Error reading list from tag", ex);
        }
        return list;
    }

    @Override
    public ItemStack getItem(Object itemTag) {
        if (itemTag == null) {
            return null;
        }
        ItemStack item = null;
        try {
            Object nmsStack = null;
            nmsStack = NMSUtils.class_ItemStack_consructor != null ? (Object)NMSUtils.class_ItemStack_consructor.newInstance(itemTag) : NMSUtils.class_ItemStack_createStackMethod.invoke(null, itemTag);
            item = (ItemStack)NMSUtils.class_CraftItemStack_mirrorMethod.invoke(null, nmsStack);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return item;
    }

    @Override
    public ItemStack[] getItems(Object rootTag, String tagName) {
        try {
            Object itemList = NMSUtils.class_NBTTagCompound_getListMethod.invoke(rootTag, tagName, 10);
            Integer size = (Integer)NMSUtils.class_NBTTagList_sizeMethod.invoke(itemList, new Object[0]);
            ItemStack[] items = new ItemStack[size.intValue()];
            for (int i = 0; i < size; ++i) {
                try {
                    Object itemData = NMSUtils.class_NBTTagList_getMethod.invoke(itemList, i);
                    if (itemData == null) continue;
                    items[i] = this.getItem(itemData);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return items;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

