/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.base.entity;

import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.entity.EntityExtraData;
import com.elmakers.mine.bukkit.entity.SpawnedEntityExtraData;
import com.elmakers.mine.bukkit.utility.ConfigUtils;
import com.elmakers.mine.bukkit.utility.platform.CompatibilityUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;

public class EntityFallingBlockData
extends EntityExtraData {
    @Nullable
    private MaterialAndData material;
    private boolean dropItem;
    private Boolean hurtEntities;

    public EntityFallingBlockData(ConfigurationSection configuration, MageController controller) {
        String materialKey = configuration.getString("material");
        if (materialKey != null && !materialKey.isEmpty()) {
            this.material = controller.createMaterialAndData(materialKey);
        }
        this.dropItem = configuration.getBoolean("drop_items", false);
        this.hurtEntities = ConfigUtils.getOptionalBoolean(configuration, "hurt_entities");
    }

    public EntityFallingBlockData(Entity entity, MageController controller) {
        CompatibilityUtils compatibilityUtils = EntityFallingBlockData.getPlatform().getCompatibilityUtils();
        if (entity instanceof FallingBlock) {
            FallingBlock fallingBlock = (FallingBlock)entity;
            Material material = compatibilityUtils.getMaterial(fallingBlock);
            String blockData = compatibilityUtils.getBlockData(fallingBlock);
            if (blockData != null) {
                this.material = controller.createMaterialAndData(material, blockData);
            } else {
                byte data = compatibilityUtils.getLegacyBlockData(fallingBlock);
                this.material = controller.createMaterialAndData(material, data);
            }
            this.dropItem = fallingBlock.getDropItem();
            this.hurtEntities = fallingBlock.canHurtEntities();
        }
    }

    @Override
    public void apply(Entity entity) {
        if (entity instanceof FallingBlock) {
            FallingBlock fallingBlock = (FallingBlock)entity;
            fallingBlock.setDropItem(this.dropItem);
            if (this.hurtEntities != null) {
                fallingBlock.setHurtEntities(this.hurtEntities.booleanValue());
            }
        }
    }

    @Override
    public void setMaterialAndData(@Nonnull MaterialAndData material) {
        this.material = material;
    }

    @Override
    @Nullable
    public MaterialAndData getMaterialAndData() {
        return this.material;
    }

    public byte getMaterialData() {
        if (this.material == null) {
            return 0;
        }
        Byte data = this.material.getBlockData();
        return data == null ? (byte)0 : data;
    }

    @Nullable
    public Material getMaterial() {
        return this.material == null ? null : this.material.getMaterial();
    }

    @Nullable
    public String getBlockData() {
        return this.material == null ? null : this.material.getModernBlockData();
    }

    @Override
    public SpawnedEntityExtraData spawn(Location location) {
        Material material = this.getMaterial();
        byte data = this.getMaterialData();
        if (material == null) {
            material = Material.DIRT;
        }
        FallingBlock newEntity = location.getWorld().spawnFallingBlock(location, material, data);
        return new SpawnedEntityExtraData((Entity)newEntity, true);
    }
}

