/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.base.entity;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.entity.EntityExtraData;
import com.elmakers.mine.bukkit.utility.ColorHD;
import com.elmakers.mine.bukkit.utility.ConfigUtils;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Entity;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;

public class EntityAreaEffectCloudData
extends EntityExtraData {
    private Color color;
    private PotionData basePotionData;
    private List<PotionEffect> potionEffects;
    private int duration;
    private int durationOnUse;
    private Particle particle;
    private float radius;
    private float radiusOnUse;
    private float radiusPerTick;
    private int reapplicationDelay;
    private int waitTime;

    public EntityAreaEffectCloudData(ConfigurationSection parameters, MageController controller) {
        String particleKey;
        String potionTypeKey;
        if (parameters.contains("color")) {
            ColorHD colorHD = new ColorHD(parameters.getString("color"));
            this.color = colorHD.getColor();
        }
        if ((potionTypeKey = parameters.getString("base_potion_type")) != null && !potionTypeKey.isEmpty()) {
            try {
                PotionType potionType = PotionType.valueOf((String)potionTypeKey.toUpperCase());
                this.basePotionData = new PotionData(potionType);
            }
            catch (Exception ex) {
                controller.getLogger().warning("Invalid base_potion_type: " + potionTypeKey);
            }
        }
        if ((particleKey = parameters.getString("particle")) != null && !particleKey.isEmpty()) {
            try {
                this.particle = Particle.valueOf((String)particleKey.toUpperCase());
            }
            catch (Exception ex) {
                controller.getLogger().warning("Invalid particle: " + particleKey);
            }
        }
        this.duration = parameters.getInt("duration", 2000) * 20 / 1000;
        this.durationOnUse = parameters.getInt("duration_on_use", 0) * 20 / 1000;
        this.reapplicationDelay = parameters.getInt("reapplication_delay", 0) * 20 / 1000;
        this.waitTime = parameters.getInt("wait_time", 0) * 20 / 1000;
        this.radius = (float)parameters.getDouble("radius", 5.0);
        this.radiusOnUse = (float)parameters.getDouble("radius_on_use", 0.0);
        this.radiusPerTick = (float)parameters.getDouble("radius_per_tick", 0.0);
        this.potionEffects = ConfigUtils.getPotionEffectObjects(parameters, "potion_effects", controller.getLogger(), this.duration);
    }

    public EntityAreaEffectCloudData(AreaEffectCloud cloud) {
        this.color = cloud.getColor();
        this.basePotionData = cloud.getBasePotionData();
        this.potionEffects = cloud.getCustomEffects();
        this.duration = cloud.getDuration();
        this.durationOnUse = cloud.getDurationOnUse();
        this.particle = cloud.getParticle();
        this.radius = cloud.getRadius();
        this.radiusOnUse = cloud.getRadiusOnUse();
        this.radiusPerTick = cloud.getRadiusPerTick();
        this.reapplicationDelay = cloud.getReapplicationDelay();
        this.waitTime = cloud.getWaitTime();
    }

    @Override
    public void apply(Entity entity) {
        if (entity instanceof AreaEffectCloud) {
            AreaEffectCloud cloud = (AreaEffectCloud)entity;
            if (this.color != null) {
                cloud.setColor(this.color);
            }
            if (this.basePotionData != null) {
                cloud.setBasePotionData(this.basePotionData);
            }
            if (this.potionEffects != null) {
                for (PotionEffect effect : this.potionEffects) {
                    cloud.addCustomEffect(effect, true);
                }
            }
            cloud.setDuration(this.duration);
            cloud.setDurationOnUse(this.durationOnUse);
            if (this.particle != null) {
                cloud.setParticle(this.particle);
            }
            cloud.setRadius(this.radius);
            cloud.setRadiusOnUse(this.radiusOnUse);
            cloud.setRadiusPerTick(this.radiusPerTick);
            cloud.setWaitTime(this.waitTime);
            cloud.setReapplicationDelay(this.reapplicationDelay);
        }
    }
}

