/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.base.entity;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.entity.EntityExtraData;
import com.elmakers.mine.bukkit.utility.ConfigUtils;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Tameable;

public class EntityAnimalData
extends EntityExtraData {
    private UUID owner;
    private Boolean tamed;
    protected Boolean sitting;

    public EntityAnimalData(ConfigurationSection parameters, MageController controller) {
        Logger log = controller.getLogger();
        String tamer = parameters.getString("owner");
        if (tamer != null && !tamer.isEmpty()) {
            try {
                this.owner = UUID.fromString(tamer);
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Invalid owner UUID: " + tamer, ex);
            }
        }
        this.tamed = this.owner != null ? Boolean.valueOf(true) : ConfigUtils.getOptionalBoolean(parameters, "tamed");
        this.sitting = ConfigUtils.getOptionalBoolean(parameters, "sitting");
    }

    public EntityAnimalData(Entity entity) {
        if (entity instanceof Tameable) {
            Tameable tameable = (Tameable)entity;
            AnimalTamer tamer = tameable.getOwner();
            if (tamer != null) {
                this.owner = tamer.getUniqueId();
            }
            this.tamed = tameable.isTamed();
        }
        this.sitting = EntityAnimalData.getPlatform().getCompatibilityUtils().isSitting(entity);
    }

    @Override
    public void apply(Entity entity) {
        if (entity instanceof Tameable) {
            OfflinePlayer owner;
            Tameable tameable = (Tameable)entity;
            if (this.owner != null && (owner = Bukkit.getOfflinePlayer((UUID)this.owner)) != null) {
                tameable.setOwner((AnimalTamer)owner);
            }
            if (this.tamed != null) {
                tameable.setTamed(this.tamed.booleanValue());
            }
        }
        if (this.sitting != null) {
            EntityAnimalData.getPlatform().getCompatibilityUtils().setSitting(entity, this.sitting);
        }
    }
}

