/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.base;

import com.elmakers.mine.bukkit.utility.Base64Coder;
import com.elmakers.mine.bukkit.utility.CompatibilityConstants;
import com.elmakers.mine.bukkit.utility.ProfileCallback;
import com.elmakers.mine.bukkit.utility.ProfileResponse;
import com.elmakers.mine.bukkit.utility.UUIDCallback;
import com.elmakers.mine.bukkit.utility.platform.Platform;
import com.elmakers.mine.bukkit.utility.platform.SkinUtils;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public abstract class SkinUtilsBase
implements SkinUtils {
    protected final Platform platform;
    protected final Map<UUID, ProfileResponse> responseCache = new HashMap<UUID, ProfileResponse>();
    protected final Map<String, UUID> uuidCache = new HashMap<String, UUID>();
    protected final Map<String, Object> loadingUUIDs = new HashMap<String, Object>();
    protected final Map<UUID, Object> loadingProfiles = new HashMap<UUID, Object>();
    protected Gson gson;
    protected long holdoff = 0L;

    protected SkinUtilsBase(Platform platform) {
        this.platform = platform;
    }

    @Override
    public Gson getGson() {
        if (this.gson == null) {
            this.gson = new Gson();
        }
        return this.gson;
    }

    @Override
    public String getTextureURL(String texturesJson) {
        JsonObject skin;
        JsonObject object;
        JsonObject texturesObject;
        String url = null;
        JsonElement element = new JsonParser().parse(texturesJson);
        if (element != null && element.isJsonObject() && (texturesObject = (object = element.getAsJsonObject()).getAsJsonObject("textures")) != null && texturesObject.has("SKIN") && (skin = texturesObject.getAsJsonObject("SKIN")) != null && skin.has("url")) {
            url = skin.get("url").getAsString();
        }
        return url;
    }

    @Override
    public String getOnlineSkinURL(Player player) {
        Object profile = this.getProfile(player);
        return profile == null ? null : this.getProfileURL(profile);
    }

    @Override
    public String getOnlineSkinURL(String playerName) {
        if (playerName.startsWith("http")) {
            return playerName;
        }
        Player player = this.platform.getDeprecatedUtils().getPlayerExact(playerName);
        String url = null;
        if (player != null) {
            url = this.getOnlineSkinURL(player);
        }
        return url;
    }

    private String fetchURL(String urlString) throws IOException {
        StringBuffer response = new StringBuffer();
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(30000);
        conn.setInstanceFollowRedirects(true);
        try (InputStream in = conn.getInputStream();){
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            String inputLine = "";
            while ((inputLine = reader.readLine()) != null) {
                response.append(inputLine);
            }
        }
        return response.toString();
    }

    private void engageHoldoff() {
        this.holdoff = 600000L;
    }

    private void synchronizeCallbackUUID(final UUIDCallback callback, final UUID uuid) {
        Bukkit.getScheduler().runTask(this.platform.getPlugin(), new Runnable(){

            @Override
            public void run() {
                callback.result(uuid);
            }
        });
    }

    private void synchronizeCallbackProfile(final ProfileCallback callback, final ProfileResponse response) {
        Bukkit.getScheduler().runTask(this.platform.getPlugin(), new Runnable(){

            @Override
            public void run() {
                callback.result(response);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fetchUUID(final String playerName, final UUIDCallback callback) {
        UUID cached;
        Player onlinePlayer = this.platform.getDeprecatedUtils().getPlayerExact(playerName);
        if (onlinePlayer != null) {
            boolean contains;
            final UUID uuid = onlinePlayer.getUniqueId();
            Map<String, UUID> map = this.uuidCache;
            synchronized (map) {
                contains = this.uuidCache.containsKey(playerName);
                if (!contains) {
                    this.uuidCache.put(playerName, onlinePlayer.getUniqueId());
                }
            }
            if (!contains) {
                Bukkit.getScheduler().runTaskAsynchronously(this.platform.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        File cacheFolder = new File(SkinUtilsBase.this.platform.getPlugin().getDataFolder(), "data/profiles");
                        if (!cacheFolder.exists()) {
                            cacheFolder.mkdirs();
                        }
                        try {
                            File playerCache = new File(cacheFolder, playerName + ".yml");
                            YamlConfiguration config = new YamlConfiguration();
                            config.set("uuid", (Object)uuid.toString());
                            config.save(playerCache);
                        }
                        catch (IOException ex) {
                            SkinUtilsBase.this.platform.getLogger().log(Level.WARNING, "Error saving to player UUID cache", ex);
                        }
                    }
                });
            }
            callback.result(onlinePlayer.getUniqueId());
            return;
        }
        Map<String, UUID> map = this.uuidCache;
        synchronized (map) {
            cached = this.uuidCache.get(playerName);
        }
        if (cached != null) {
            callback.result(cached);
            return;
        }
        Bukkit.getScheduler().runTaskLaterAsynchronously(this.platform.getPlugin(), new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object lock;
                Object object = SkinUtilsBase.this.loadingUUIDs;
                synchronized (object) {
                    lock = SkinUtilsBase.this.loadingUUIDs.get(playerName);
                    if (lock == null) {
                        lock = new Object();
                        SkinUtilsBase.this.loadingUUIDs.put(playerName, lock);
                    }
                }
                object = lock;
                synchronized (object) {
                    UUID uuid;
                    UUID cached;
                    Map<String, UUID> map = SkinUtilsBase.this.uuidCache;
                    synchronized (map) {
                        cached = SkinUtilsBase.this.uuidCache.get(playerName);
                    }
                    if (cached != null) {
                        callback.result(cached);
                        return;
                    }
                    File cacheFolder = new File(SkinUtilsBase.this.platform.getPlugin().getDataFolder(), "data/profiles");
                    if (!cacheFolder.exists()) {
                        cacheFolder.mkdirs();
                    }
                    File playerCache = new File(cacheFolder, playerName + ".yml");
                    try {
                        Object uuidJSON;
                        if (playerCache.exists()) {
                            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)playerCache);
                            uuid = UUID.fromString(config.getString("uuid"));
                        } else {
                            uuidJSON = SkinUtilsBase.this.fetchURL("https://api.mojang.com/users/profiles/minecraft/" + playerName);
                            if (((String)uuidJSON).isEmpty()) {
                                if (CompatibilityConstants.DEBUG) {
                                    SkinUtilsBase.this.platform.getLogger().warning("Got empty UUID JSON for " + playerName);
                                }
                                SkinUtilsBase.this.synchronizeCallbackUUID(callback, null);
                                return;
                            }
                            String uuidString = null;
                            JsonElement element = new JsonParser().parse((String)uuidJSON);
                            if (element != null && element.isJsonObject()) {
                                uuidString = element.getAsJsonObject().get("id").getAsString();
                            }
                            if (uuidString == null) {
                                SkinUtilsBase.this.engageHoldoff();
                                if (CompatibilityConstants.DEBUG) {
                                    SkinUtilsBase.this.platform.getLogger().warning("Failed to parse UUID JSON for " + playerName + ", will not retry for 10 minutes");
                                }
                                SkinUtilsBase.this.synchronizeCallbackUUID(callback, null);
                                return;
                            }
                            if (CompatibilityConstants.DEBUG) {
                                SkinUtilsBase.this.platform.getLogger().info("Got UUID: " + uuidString + " for " + playerName);
                            }
                            uuid = UUID.fromString(SkinUtilsBase.this.addDashes(uuidString));
                            YamlConfiguration config = new YamlConfiguration();
                            config.set("uuid", (Object)uuid.toString());
                            config.save(playerCache);
                        }
                        uuidJSON = SkinUtilsBase.this.uuidCache;
                        synchronized (uuidJSON) {
                            SkinUtilsBase.this.uuidCache.put(playerName, uuid);
                        }
                    }
                    catch (Exception ex) {
                        if (CompatibilityConstants.DEBUG) {
                            SkinUtilsBase.this.platform.getLogger().log(Level.WARNING, "Failed to fetch UUID for: " + playerName + ", will not retry for 10 minutes", ex);
                        } else {
                            SkinUtilsBase.this.platform.getLogger().log(Level.WARNING, "Failed to fetch UUID for: " + playerName + ", will not retry for 10 minutes");
                        }
                        SkinUtilsBase.this.engageHoldoff();
                        uuid = null;
                    }
                    SkinUtilsBase.this.synchronizeCallbackUUID(callback, uuid);
                }
            }
        }, this.holdoff / 50L);
    }

    private String addDashes(String uuidString) {
        StringBuilder builder = new StringBuilder(uuidString);
        int i = 8;
        int j = 0;
        while (i <= 20) {
            builder.insert(i + j, '-');
            i += 4;
            ++j;
        }
        return builder.toString();
    }

    @Override
    public void fetchProfile(String playerName, final ProfileCallback callback) {
        this.fetchUUID(playerName, new UUIDCallback(){

            @Override
            public void result(UUID uuid) {
                if (uuid != null) {
                    SkinUtilsBase.this.fetchProfile(uuid, callback);
                } else {
                    callback.result(null);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fetchProfile(final UUID uuid, final ProfileCallback callback) {
        ProfileResponse cached;
        Player onlinePlayer = Bukkit.getPlayer((UUID)uuid);
        if (onlinePlayer != null) {
            boolean contains;
            final ProfileResponse response = new ProfileResponse(this, this.platform.getLogger(), onlinePlayer);
            Map<UUID, ProfileResponse> map = this.responseCache;
            synchronized (map) {
                contains = this.responseCache.containsKey(uuid);
                if (!contains) {
                    this.responseCache.put(uuid, response);
                }
            }
            if (!contains) {
                Bukkit.getScheduler().runTaskAsynchronously(this.platform.getPlugin(), new Runnable(){

                    @Override
                    public void run() {
                        File cacheFolder = new File(SkinUtilsBase.this.platform.getPlugin().getDataFolder(), "data/profiles");
                        if (!cacheFolder.exists()) {
                            cacheFolder.mkdirs();
                        }
                        try {
                            File playerCache = new File(cacheFolder, uuid + ".yml");
                            YamlConfiguration config = new YamlConfiguration();
                            response.save((ConfigurationSection)config);
                            config.save(playerCache);
                        }
                        catch (IOException ex) {
                            SkinUtilsBase.this.platform.getLogger().log(Level.WARNING, "Error saving to player profile cache", ex);
                        }
                    }
                });
            }
            callback.result(response);
            return;
        }
        Map<UUID, ProfileResponse> response = this.responseCache;
        synchronized (response) {
            cached = this.responseCache.get(uuid);
        }
        if (cached != null) {
            callback.result(cached);
            return;
        }
        final SkinUtilsBase skinUtils = this;
        Plugin plugin = this.platform.getPlugin();
        Bukkit.getScheduler().runTaskLaterAsynchronously(plugin, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object lock;
                Object object = SkinUtilsBase.this.loadingUUIDs;
                synchronized (object) {
                    lock = SkinUtilsBase.this.loadingProfiles.get(uuid);
                    if (lock == null) {
                        lock = new Object();
                        SkinUtilsBase.this.loadingProfiles.put(uuid, lock);
                    }
                }
                object = lock;
                synchronized (object) {
                    File playerCache;
                    ProfileResponse cached;
                    Map<UUID, ProfileResponse> map = SkinUtilsBase.this.responseCache;
                    synchronized (map) {
                        cached = SkinUtilsBase.this.responseCache.get(uuid);
                    }
                    if (cached != null) {
                        SkinUtilsBase.this.synchronizeCallbackProfile(callback, cached);
                        return;
                    }
                    File cacheFolder = new File(SkinUtilsBase.this.platform.getPlugin().getDataFolder(), "data/profiles");
                    if (!cacheFolder.exists()) {
                        cacheFolder.mkdirs();
                    }
                    if ((playerCache = new File(cacheFolder, uuid + ".yml")).exists()) {
                        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)playerCache);
                        ProfileResponse fromCache = new ProfileResponse(skinUtils, (ConfigurationSection)config);
                        Map<UUID, ProfileResponse> map2 = SkinUtilsBase.this.responseCache;
                        synchronized (map2) {
                            SkinUtilsBase.this.responseCache.put(uuid, fromCache);
                        }
                        SkinUtilsBase.this.synchronizeCallbackProfile(callback, fromCache);
                        return;
                    }
                    if (CompatibilityConstants.DEBUG) {
                        SkinUtilsBase.this.platform.getLogger().info("Fetching profile for " + uuid);
                    }
                    try {
                        JsonElement element;
                        String profileJSON = SkinUtilsBase.this.fetchURL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid.toString().replace("-", ""));
                        if (profileJSON.isEmpty()) {
                            SkinUtilsBase.this.synchronizeCallbackProfile(callback, null);
                            SkinUtilsBase.this.engageHoldoff();
                            if (CompatibilityConstants.DEBUG) {
                                SkinUtilsBase.this.platform.getLogger().warning("Failed to fetch profile JSON for " + uuid + ", will not retry for 10 minutes");
                            }
                            return;
                        }
                        if (CompatibilityConstants.DEBUG) {
                            SkinUtilsBase.this.platform.getLogger().info("Got profile: " + profileJSON);
                        }
                        if ((element = new JsonParser().parse(profileJSON)) == null || !element.isJsonObject()) {
                            SkinUtilsBase.this.synchronizeCallbackProfile(callback, null);
                            SkinUtilsBase.this.engageHoldoff();
                            if (CompatibilityConstants.DEBUG) {
                                SkinUtilsBase.this.platform.getLogger().warning("Failed to parse profile JSON for " + uuid + ", will not retry for 10 minutes");
                            }
                            return;
                        }
                        JsonObject profileJson = element.getAsJsonObject();
                        JsonArray properties = profileJson.getAsJsonArray("properties");
                        String encodedTextures = null;
                        for (int i = 0; i < properties.size(); ++i) {
                            JsonObject objectProperty;
                            JsonElement property = properties.get(i);
                            if (!property.isJsonObject() || !(objectProperty = property.getAsJsonObject()).has("name") || !objectProperty.has("value") || !objectProperty.get("name").getAsString().equals("textures")) continue;
                            encodedTextures = objectProperty.get("value").getAsString();
                            break;
                        }
                        if (encodedTextures == null) {
                            SkinUtilsBase.this.synchronizeCallbackProfile(callback, null);
                            SkinUtilsBase.this.engageHoldoff();
                            if (CompatibilityConstants.DEBUG) {
                                SkinUtilsBase.this.platform.getLogger().warning("Failed to find textures in profile JSON, will not retry for 10 minutes");
                            }
                            return;
                        }
                        String decodedTextures = Base64Coder.decodeString(encodedTextures);
                        if (CompatibilityConstants.DEBUG) {
                            SkinUtilsBase.this.platform.getLogger().info("Decoded textures: " + decodedTextures);
                        }
                        String skinURL = SkinUtilsBase.this.getTextureURL(decodedTextures);
                        if (CompatibilityConstants.DEBUG) {
                            SkinUtilsBase.this.platform.getLogger().info("Got skin URL: " + skinURL + " for " + profileJson.get("name").getAsString());
                        }
                        ProfileResponse response = new ProfileResponse(skinUtils, uuid, profileJson.get("name").getAsString(), skinURL, profileJSON);
                        Map<UUID, ProfileResponse> map3 = SkinUtilsBase.this.responseCache;
                        synchronized (map3) {
                            SkinUtilsBase.this.responseCache.put(uuid, response);
                        }
                        YamlConfiguration saveToCache = new YamlConfiguration();
                        response.save((ConfigurationSection)saveToCache);
                        saveToCache.save(playerCache);
                        SkinUtilsBase.this.synchronizeCallbackProfile(callback, response);
                        SkinUtilsBase.this.holdoff = 0L;
                    }
                    catch (Exception ex) {
                        if (CompatibilityConstants.DEBUG) {
                            SkinUtilsBase.this.platform.getLogger().log(Level.WARNING, "Failed to fetch profile for: " + uuid + ", will not retry for 10 minutes", ex);
                        } else {
                            SkinUtilsBase.this.platform.getLogger().log(Level.WARNING, "Failed to fetch profile for: " + uuid + ", will not retry for 10 minutes");
                        }
                        SkinUtilsBase.this.engageHoldoff();
                        SkinUtilsBase.this.synchronizeCallbackProfile(callback, null);
                    }
                }
            }
        }, this.holdoff / 50L);
    }
}

