/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility.platform.base;

import com.elmakers.mine.bukkit.utility.platform.NBTUtils;
import com.elmakers.mine.bukkit.utility.platform.Platform;
import org.bukkit.inventory.ItemStack;

public abstract class NBTUtilsBase
implements NBTUtils {
    protected final Platform platform;

    protected NBTUtilsBase(Platform platform) {
        this.platform = platform;
    }

    @Override
    public boolean containsTag(ItemStack stack, String tag) {
        if (this.platform.getItemUtils().isEmpty(stack)) {
            return false;
        }
        return this.getTag(stack, tag) != null;
    }

    @Override
    public String getString(ItemStack stack, String tag, String defaultValue) {
        String result = this.getString(stack, tag);
        return result == null ? defaultValue : result;
    }

    @Override
    public String getString(Object node, String tag, String defaultValue) {
        String meta = this.getString(node, tag);
        return meta == null || meta.length() == 0 ? defaultValue : meta;
    }

    @Override
    public short getShort(Object node, String tag, short defaultValue) {
        Short meta = this.getOptionalShort(node, tag);
        return meta == null ? defaultValue : meta;
    }

    @Override
    public int getInt(Object node, String tag, int defaultValue) {
        Integer meta = this.getOptionalInt(node, tag);
        return meta == null ? defaultValue : meta;
    }

    @Override
    public int getInt(ItemStack stack, String tag, int defaultValue) {
        if (this.platform.getItemUtils().isEmpty(stack)) {
            return defaultValue;
        }
        int result = defaultValue;
        try {
            Object tagObject = this.platform.getItemUtils().getTag(stack);
            if (tagObject == null) {
                return defaultValue;
            }
            Integer value = this.getOptionalInt(tagObject, tag);
            result = value == null ? defaultValue : value;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Override
    public void setInt(ItemStack stack, String tag, int value) {
        if (this.platform.getItemUtils().isEmpty(stack)) {
            return;
        }
        try {
            Object craft = this.platform.getItemUtils().getHandle(stack);
            if (craft == null) {
                return;
            }
            Object tagObject = this.platform.getItemUtils().getTag(craft);
            if (tagObject == null) {
                return;
            }
            this.setInt(tagObject, tag, value);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void removeMeta(ItemStack stack, String tag) {
        if (this.platform.getItemUtils().isEmpty(stack)) {
            return;
        }
        try {
            Object craft = this.platform.getItemUtils().getHandle(stack);
            if (craft == null) {
                return;
            }
            Object tagObject = this.platform.getItemUtils().getTag(craft);
            if (tagObject == null) {
                return;
            }
            this.removeMeta(tagObject, tag);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void parseAndSet(Object node, String tag, String value) {
        if (value == null) {
            this.removeMeta(node, tag);
            return;
        }
        boolean isTrue = value.equals("true");
        boolean isFalse = value.equals("false");
        if (isTrue || isFalse) {
            this.setBoolean(node, tag, isTrue);
        } else {
            try {
                Integer i = Integer.parseInt(value);
                this.setInt(node, tag, (int)i);
            }
            catch (Exception ex) {
                try {
                    Double d = Double.parseDouble(value);
                    this.setDouble(node, tag, d);
                }
                catch (Exception ex2) {
                    this.setString(node, tag, value);
                }
            }
        }
    }

    @Override
    public void setBoolean(ItemStack stack, String tag, boolean value) {
        if (this.platform.getItemUtils().isEmpty(stack)) {
            return;
        }
        try {
            Object craft = this.platform.getItemUtils().getHandle(stack);
            if (craft == null) {
                return;
            }
            Object tagObject = this.platform.getItemUtils().getTag(craft);
            if (tagObject == null) {
                return;
            }
            this.setBoolean(tagObject, tag, value);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean getBoolean(ItemStack stack, String tag, boolean defaultValue) {
        if (this.platform.getItemUtils().isEmpty(stack)) {
            return defaultValue;
        }
        boolean result = defaultValue;
        try {
            Object tagObject = this.platform.getItemUtils().getTag(stack);
            if (tagObject == null) {
                return defaultValue;
            }
            Boolean value = this.getOptionalBoolean(tagObject, tag);
            result = value == null ? defaultValue : value;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return result;
    }
}

