/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;

public class DirectionUtils {
    public static final String[] EXAMPLE_DIRECTIONS = new String[]{"cardinal", "all", "plane", "neighbors", "up", "down", "north", "south", "east", "west"};
    private static final List<com.elmakers.mine.bukkit.block.BlockFace> cardinalDirections = Arrays.asList(com.elmakers.mine.bukkit.block.BlockFace.NORTH, com.elmakers.mine.bukkit.block.BlockFace.SOUTH, com.elmakers.mine.bukkit.block.BlockFace.EAST, com.elmakers.mine.bukkit.block.BlockFace.WEST, com.elmakers.mine.bukkit.block.BlockFace.UP, com.elmakers.mine.bukkit.block.BlockFace.DOWN);
    private static final List<com.elmakers.mine.bukkit.block.BlockFace> neighborDirections = Arrays.asList(com.elmakers.mine.bukkit.block.BlockFace.NORTH, com.elmakers.mine.bukkit.block.BlockFace.SOUTH, com.elmakers.mine.bukkit.block.BlockFace.EAST, com.elmakers.mine.bukkit.block.BlockFace.WEST);
    private static final List<com.elmakers.mine.bukkit.block.BlockFace> allDirections = Arrays.asList(com.elmakers.mine.bukkit.block.BlockFace.UP, com.elmakers.mine.bukkit.block.BlockFace.DOWN, com.elmakers.mine.bukkit.block.BlockFace.NORTH, com.elmakers.mine.bukkit.block.BlockFace.SOUTH, com.elmakers.mine.bukkit.block.BlockFace.EAST, com.elmakers.mine.bukkit.block.BlockFace.WEST, com.elmakers.mine.bukkit.block.BlockFace.NORTH_EAST, com.elmakers.mine.bukkit.block.BlockFace.NORTH_WEST, com.elmakers.mine.bukkit.block.BlockFace.SOUTH_EAST, com.elmakers.mine.bukkit.block.BlockFace.SOUTH_WEST, com.elmakers.mine.bukkit.block.BlockFace.UP_NORTH, com.elmakers.mine.bukkit.block.BlockFace.UP_EAST, com.elmakers.mine.bukkit.block.BlockFace.UP_SOUTH, com.elmakers.mine.bukkit.block.BlockFace.UP_WEST, com.elmakers.mine.bukkit.block.BlockFace.UP_NORTH_EAST, com.elmakers.mine.bukkit.block.BlockFace.UP_NORTH_WEST, com.elmakers.mine.bukkit.block.BlockFace.UP_SOUTH_EAST, com.elmakers.mine.bukkit.block.BlockFace.UP_SOUTH_WEST, com.elmakers.mine.bukkit.block.BlockFace.DOWN_NORTH, com.elmakers.mine.bukkit.block.BlockFace.DOWN_EAST, com.elmakers.mine.bukkit.block.BlockFace.DOWN_SOUTH, com.elmakers.mine.bukkit.block.BlockFace.DOWN_WEST, com.elmakers.mine.bukkit.block.BlockFace.DOWN_NORTH_EAST, com.elmakers.mine.bukkit.block.BlockFace.DOWN_NORTH_WEST, com.elmakers.mine.bukkit.block.BlockFace.DOWN_SOUTH_EAST, com.elmakers.mine.bukkit.block.BlockFace.DOWN_SOUTH_WEST);
    private static final List<com.elmakers.mine.bukkit.block.BlockFace> planeDirections = Arrays.asList(com.elmakers.mine.bukkit.block.BlockFace.NORTH, com.elmakers.mine.bukkit.block.BlockFace.SOUTH, com.elmakers.mine.bukkit.block.BlockFace.EAST, com.elmakers.mine.bukkit.block.BlockFace.WEST, com.elmakers.mine.bukkit.block.BlockFace.NORTH_EAST, com.elmakers.mine.bukkit.block.BlockFace.NORTH_WEST, com.elmakers.mine.bukkit.block.BlockFace.SOUTH_EAST, com.elmakers.mine.bukkit.block.BlockFace.SOUTH_WEST);

    @Nullable
    public static com.elmakers.mine.bukkit.block.BlockFace getBlockFace(String name) {
        try {
            return com.elmakers.mine.bukkit.block.BlockFace.valueOf(name.toUpperCase());
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    public static List<com.elmakers.mine.bukkit.block.BlockFace> getDirections(String name) {
        if (name == null) {
            return null;
        }
        if (name.equalsIgnoreCase("cardinal")) {
            return cardinalDirections;
        }
        if (name.equalsIgnoreCase("all")) {
            return allDirections;
        }
        if (name.equalsIgnoreCase("plane")) {
            return planeDirections;
        }
        if (name.equalsIgnoreCase("neighbors")) {
            return neighborDirections;
        }
        com.elmakers.mine.bukkit.block.BlockFace single = DirectionUtils.getBlockFace(name);
        if (single == null) {
            return null;
        }
        ArrayList<com.elmakers.mine.bukkit.block.BlockFace> singleSet = new ArrayList<com.elmakers.mine.bukkit.block.BlockFace>();
        singleSet.add(single);
        return singleSet;
    }

    @Nonnull
    public static List<com.elmakers.mine.bukkit.block.BlockFace> getDirections(ConfigurationSection parameters, String key) {
        List<String> faceList;
        List<com.elmakers.mine.bukkit.block.BlockFace> faceSet = null;
        if (parameters.isString(key)) {
            String name = parameters.getString(key);
            faceSet = DirectionUtils.getDirections(name);
        }
        if (faceSet == null && (faceList = ConfigurationUtils.getStringList(parameters, key)) != null) {
            faceSet = new ArrayList<com.elmakers.mine.bukkit.block.BlockFace>();
            for (String face : faceList) {
                faceSet.addAll(DirectionUtils.getDirections(face));
            }
        }
        if (faceSet == null) {
            faceSet = cardinalDirections;
        }
        return faceSet;
    }

    public static BlockFace getDirection(int yaw) {
        byte data = (byte)(yaw * 15 / 360);
        switch (data) {
            case 0: {
                return BlockFace.SOUTH;
            }
            case 1: {
                return BlockFace.SOUTH_SOUTH_WEST;
            }
            case 2: {
                return BlockFace.SOUTH_WEST;
            }
            case 3: {
                return BlockFace.WEST_SOUTH_WEST;
            }
            case 4: {
                return BlockFace.WEST;
            }
            case 5: {
                return BlockFace.WEST_NORTH_WEST;
            }
            case 6: {
                return BlockFace.NORTH_WEST;
            }
            case 7: {
                return BlockFace.NORTH_NORTH_WEST;
            }
            case 8: {
                return BlockFace.NORTH;
            }
            case 9: {
                return BlockFace.NORTH_NORTH_EAST;
            }
            case 10: {
                return BlockFace.NORTH_EAST;
            }
            case 11: {
                return BlockFace.EAST_NORTH_EAST;
            }
            case 12: {
                return BlockFace.EAST;
            }
            case 13: {
                return BlockFace.EAST_SOUTH_EAST;
            }
            case 14: {
                return BlockFace.SOUTH_EAST;
            }
            case 15: {
                return BlockFace.SOUTH_SOUTH_EAST;
            }
        }
        return BlockFace.SELF;
    }

    public static BlockFace goLeft(BlockFace direction) {
        switch (direction) {
            case EAST: {
                return BlockFace.NORTH;
            }
            case NORTH: {
                return BlockFace.WEST;
            }
            case WEST: {
                return BlockFace.SOUTH;
            }
            case SOUTH: {
                return BlockFace.EAST;
            }
        }
        return direction;
    }

    public static BlockFace goRight(BlockFace direction) {
        switch (direction) {
            case EAST: {
                return BlockFace.SOUTH;
            }
            case SOUTH: {
                return BlockFace.WEST;
            }
            case WEST: {
                return BlockFace.NORTH;
            }
            case NORTH: {
                return BlockFace.EAST;
            }
        }
        return direction;
    }
}

