/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Color;
import org.bukkit.configuration.ConfigurationSection;

@Immutable
public final class ColorHD {
    private static long BYTES_PER_COMPONENT = 6L;
    private static long BITS_PER_COMPONENT = BYTES_PER_COMPONENT * 8L;
    private static long COMPONENT_SHIFT = BITS_PER_COMPONENT - 8L;
    private static long BIT_MASK = (1L << (int)BITS_PER_COMPONENT) - 1L;
    private static final int[] components = new int[3];
    private static Map<String, Color> colorMap;
    private final long red;
    private final long green;
    private final long blue;
    private final Color color;

    public ColorHD(long r, long g, long b) {
        this.red = r & BIT_MASK;
        this.blue = b & BIT_MASK;
        this.green = g & BIT_MASK;
        this.color = this.createColor();
    }

    public ColorHD(Color color) {
        this(color.getRed() << (int)COMPONENT_SHIFT, color.getGreen() << (int)COMPONENT_SHIFT, color.getBlue() << (int)COMPONENT_SHIFT);
    }

    public ColorHD(ConfigurationSection configuration) {
        if (configuration.contains("r")) {
            this.red = (long)configuration.getInt("r") << (int)COMPONENT_SHIFT;
            this.green = (long)configuration.getInt("g") << (int)COMPONENT_SHIFT;
            this.blue = (long)configuration.getInt("b") << (int)COMPONENT_SHIFT;
        } else if (configuration.contains("h")) {
            float h = (float)configuration.getDouble("h");
            float s = (float)configuration.getDouble("s");
            float v = (float)configuration.getDouble("v", configuration.getDouble("b"));
            int[] colors = ColorHD.convertHSBtoRGB(h, s, v);
            this.red = (long)(colors[0] & 0xFF) << (int)COMPONENT_SHIFT;
            this.green = (long)(colors[1] & 0xFF) << (int)COMPONENT_SHIFT;
            this.blue = (long)(colors[2] & 0xFF) << (int)COMPONENT_SHIFT;
        } else {
            this.red = 0L;
            this.green = 0L;
            this.blue = 0L;
        }
        this.color = this.createColor();
    }

    public ColorHD(String hexColor) {
        if (hexColor != null && !hexColor.isEmpty() && hexColor.charAt(0) == '#') {
            hexColor = hexColor.substring(1, hexColor.length());
        }
        if (hexColor == null || hexColor.length() == 0) {
            this.red = 0L;
            this.green = 0L;
            this.blue = 0L;
        } else if (hexColor.equals("random")) {
            this.red = (long)(Math.random() * (double)BIT_MASK);
            this.green = (long)(Math.random() * (double)BIT_MASK);
            this.blue = (long)(Math.random() * (double)BIT_MASK);
        } else if (hexColor.length() > 6 && hexColor.contains(",")) {
            String[] pieces = StringUtils.split((String)hexColor, (char)',');
            long r = 0L;
            long g = 0L;
            long b = 0L;
            if (pieces.length == 3) {
                try {
                    r = Long.parseLong(pieces[0], 16);
                    g = Long.parseLong(pieces[1], 16);
                    b = Long.parseLong(pieces[2], 16);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.red = r;
            this.green = g;
            this.blue = b;
        } else {
            Color namedColor = ColorHD.getColorByName(hexColor);
            if (namedColor != null) {
                this.red = (long)namedColor.getRed() << (int)COMPONENT_SHIFT;
                this.blue = (long)namedColor.getBlue() << (int)COMPONENT_SHIFT;
                this.green = (long)namedColor.getGreen() << (int)COMPONENT_SHIFT;
            } else {
                long effectColor = 0L;
                try {
                    effectColor = Integer.parseInt(hexColor, 16);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.red = (effectColor >> 16 & 0xFFL) << (int)COMPONENT_SHIFT;
                this.green = (effectColor >> 8 & 0xFFL) << (int)COMPONENT_SHIFT;
                this.blue = (effectColor & 0xFFL) << (int)COMPONENT_SHIFT;
            }
        }
        this.color = this.createColor();
    }

    public static int[] convertHSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        ColorHD.components[0] = r;
        ColorHD.components[1] = g;
        ColorHD.components[2] = b;
        return components;
    }

    public Color getColor() {
        return this.color;
    }

    public String toString() {
        return Long.toHexString(this.red) + "," + Long.toHexString(this.green) + "," + Long.toHexString(this.blue);
    }

    public ColorHD mixColor(long r, long g, long b, double weight) {
        double totalWeight = weight + 1.0;
        double totalRed = (double)this.red + (double)r * weight;
        double totalGreen = (double)this.green + (double)g * weight;
        double totalBlue = (double)this.blue + (double)b * weight;
        return new ColorHD((long)(totalRed / totalWeight), (long)(totalGreen / totalWeight), (long)(totalBlue / totalWeight));
    }

    public ColorHD mixColor(ColorHD other, double weight) {
        return this.mixColor(other.red, other.green, other.blue, weight);
    }

    public ColorHD mixColor(Color other, double weight) {
        if (other == null) {
            return this;
        }
        return this.mixColor(this.color.getRed() << (int)COMPONENT_SHIFT, this.color.getGreen() << (int)COMPONENT_SHIFT, this.color.getBlue() << (int)COMPONENT_SHIFT, weight);
    }

    public static double getDistance(Color c1, Color c2) {
        double rmean = (double)(c1.getRed() + c2.getRed()) / 2.0;
        double r = c1.getRed() - c2.getRed();
        double g = c1.getGreen() - c2.getGreen();
        int b = c1.getBlue() - c2.getBlue();
        double weightR = 2.0 + rmean / 256.0;
        double weightG = 4.0;
        double weightB = 2.0 + (255.0 - rmean) / 256.0;
        return weightR * r * r + weightG * g * g + weightB * (double)b * (double)b;
    }

    private static Color getColorByName(String name) {
        if (colorMap == null) {
            colorMap = new HashMap<String, Color>();
            colorMap.put("WHITE", Color.fromRGB((int)0xFFFFFF));
            colorMap.put("SILVER", Color.fromRGB((int)0xC0C0C0));
            colorMap.put("GRAY", Color.fromRGB((int)0x808080));
            colorMap.put("BLACK", Color.fromRGB((int)0));
            colorMap.put("RED", Color.fromRGB((int)0xFF0000));
            colorMap.put("MAROON", Color.fromRGB((int)0x800000));
            colorMap.put("YELLOW", Color.fromRGB((int)0xFFFF00));
            colorMap.put("OLIVE", Color.fromRGB((int)0x808000));
            colorMap.put("LIME", Color.fromRGB((int)65280));
            colorMap.put("GREEN", Color.fromRGB((int)32768));
            colorMap.put("AQUA", Color.fromRGB((int)65535));
            colorMap.put("TEAL", Color.fromRGB((int)32896));
            colorMap.put("BLUE", Color.fromRGB((int)255));
            colorMap.put("NAVY", Color.fromRGB((int)128));
            colorMap.put("FUCHSIA", Color.fromRGB((int)0xFF00FF));
            colorMap.put("PURPLE", Color.fromRGB((int)0x800080));
            colorMap.put("ORANGE", Color.fromRGB((int)16753920));
        }
        return colorMap.get(name.toUpperCase());
    }

    private Color createColor() {
        Color testCreate = null;
        try {
            testCreate = Color.fromRGB((int)((int)(this.red >> (int)COMPONENT_SHIFT)), (int)((int)(this.green >> (int)COMPONENT_SHIFT)), (int)((int)(this.blue >> (int)COMPONENT_SHIFT)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (testCreate == null) {
            testCreate = Color.BLACK;
        }
        return testCreate;
    }
}

