/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BlockSpell;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;

public class StairsSpell
extends BlockSpell {
    private int defaultDepth = 4;
    private int defaultWidth = 3;
    private int defaultHeight = 3;
    private int torchFrequency = 4;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Block targetBlock = this.getTargetBlock();
        if (targetBlock == null) {
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(targetBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        this.defaultDepth = parameters.getInt("depth", this.defaultDepth);
        this.defaultWidth = parameters.getInt("width", this.defaultWidth);
        this.defaultHeight = parameters.getInt("height", this.defaultHeight);
        this.torchFrequency = parameters.getInt("torch_frequency", this.torchFrequency);
        this.createStairs(targetBlock);
        return SpellResult.CAST;
    }

    protected void createStairs(Block targetBlock) {
        Block bottomBlock;
        BlockFace vertDirection = BlockFace.UP;
        BlockFace horzDirection = this.getPlayerFacing();
        int depth = this.defaultDepth;
        int height = this.defaultHeight;
        int width = this.defaultWidth;
        Material fillMaterial = targetBlock.getType();
        BlockFace toTheLeft = StairsSpell.goLeft(horzDirection);
        BlockFace toTheRight = StairsSpell.goRight(horzDirection);
        Block bottomLeftBlock = bottomBlock = targetBlock;
        for (int i = 0; i < width / 2; ++i) {
            bottomLeftBlock = bottomLeftBlock.getRelative(toTheLeft);
        }
        targetBlock = bottomLeftBlock;
        Material stairsMaterial = Material.COBBLESTONE_STAIRS;
        for (int d = 0; d < depth; ++d) {
            bottomBlock = bottomLeftBlock;
            for (int w = 0; w < width; ++w) {
                targetBlock = bottomBlock;
                for (int h = 0; h < height; ++h) {
                    if (this.isDestructible(targetBlock) && this.hasBuildPermission(targetBlock)) {
                        boolean useStairs;
                        Block checkBlock = null;
                        checkBlock = w == 0 ? targetBlock.getRelative(toTheLeft) : targetBlock.getRelative(toTheRight);
                        boolean useTorch = this.torchFrequency > 0 && (w == 0 || w == width - 1) && h == 1 && d % this.torchFrequency == 0 && checkBlock.getType() != Material.AIR;
                        boolean bl = useStairs = h == 0;
                        if (useStairs) {
                            this.registerForUndo(targetBlock);
                            targetBlock.setType(stairsMaterial);
                        } else if (useTorch) {
                            this.registerForUndo(targetBlock);
                            targetBlock.setType(Material.TORCH);
                        } else {
                            this.registerForUndo(targetBlock);
                            targetBlock.setType(Material.AIR);
                        }
                        Block standingBlock = targetBlock.getRelative(BlockFace.DOWN);
                        if (standingBlock.getType() == Material.AIR) {
                            this.registerForUndo(standingBlock);
                            standingBlock.setType(fillMaterial);
                        }
                    }
                    targetBlock = targetBlock.getRelative(BlockFace.UP);
                }
                bottomBlock = bottomBlock.getRelative(toTheRight);
            }
            bottomLeftBlock = bottomLeftBlock.getRelative(horzDirection);
            bottomLeftBlock = bottomLeftBlock.getRelative(vertDirection);
        }
        this.registerForUndo();
    }

    protected void createSpiralStairs(Block targetBlock) {
    }
}

